# Copyright (C) king.com Ltd 2025
# License: Apache 2.0

# call like this: bash run_tuning.sh  "path/to/pdt_checkpoint_file"
echo "Running prompt tuning with PDT model $1"

# =============================================
# Evaluation / Prompt-tuning on (subset of) ID training tasks
# ===================vvv=======================
python pdt_main.py --evaluation --eval_train_task --load_path $1 --prompt_tune --prompt_tuner "bandit"
python pdt_main.py --evaluation --eval_train_task --load_path $1 --prompt_tune --prompt_tuner "bandit" --bandit-use-transformer-features
python pdt_main.py --evaluation --eval_train_task --load_path $1 --prompt_tune --prompt_tuner "bandit_ts"
python pdt_main.py --evaluation --eval_train_task --load_path $1 --prompt_tune --prompt_tuner "bandit_ts" --bandit-use-transformer-features
python pdt_main.py --evaluation --eval_train_task --load_path $1 --prompt_tune --prompt_tuner "bandit_ucb"
python pdt_main.py --evaluation --eval_train_task --load_path $1 --prompt_tune --prompt_tuner "bandit_ucb" --bandit-use-transformer-features
python pdt_main.py --evaluation --eval_train_task --load_path $1 --prompt_tune --prompt_tuner "hillclimbing"
python pdt_main.py --evaluation --eval_train_task --load_path $1 --prompt_tune --prompt_tuner "zoranksgd"
python pdt_main.py --evaluation --eval_train_task --load_path $1  # no tuning baseline



# =============================================
# Evaluation / Prompt-tuning on OOD test tasks
# ===================vvv=======================
python pdt_main.py --evaluation --load_path $1 --prompt_tune --prompt_tuner "bandit"
python pdt_main.py --evaluation --load_path $1 --prompt_tune --prompt_tuner "bandit" --bandit-use-transformer-features
python pdt_main.py --evaluation --load_path $1 --prompt_tune --prompt_tuner "bandit_ts"
python pdt_main.py --evaluation --load_path $1 --prompt_tune --prompt_tuner "bandit_ts" --bandit-use-transformer-features
python pdt_main.py --evaluation --load_path $1 --prompt_tune --prompt_tuner "bandit_ucb"
python pdt_main.py --evaluation --load_path $1 --prompt_tune --prompt_tuner "bandit_ucb" --bandit-use-transformer-features
python pdt_main.py --evaluation --load_path $1 --prompt_tune --prompt_tuner "hillclimbing"
python pdt_main.py --evaluation --load_path $1 --prompt_tune --prompt_tuner "zoranksgd"
python pdt_main.py --evaluation --load_path $1  # no tuning baseline
