# Copyright (C) king.com Ltd 2025
# License: Apache 2.0

from gymnasium import register
import numpy as np

for target_radius in [0.9, 1.9, 2.9]:
    # for target_angle in [0, 0.1, 0.15, 0.2, 0.3]:
    for target_angle in np.linspace(0, 1.9, 20):
        env_id = f"CircleStopEnv-angle{target_angle:.1f}_radius{target_radius}-v0"
        # print("Registering env with id:", env_id)
        register(
            id=env_id,
            entry_point="envs.continuous_stop_env:ContinuousTerminationEnv",
            kwargs={
                "target_angle": target_angle * np.pi,
                "target_radius": target_radius,
            }
        )

register(
    id=f"CircleStopEnv-angle0_randomRad-v0",
    entry_point="envs.continuous_stop_env:ContinuousTerminationEnv",
    kwargs={
        "target_angle": 0,
        "target_radius": 0.9,
        "random_radius": True,
    }
)

register(
    id=f"CircleStopEnv-randomAngle_randomRad-v0",
    entry_point="envs.continuous_stop_env:ContinuousTerminationEnv",
    kwargs={
        "target_angle": 0,
        "target_radius": 0.9,
        "random_radius": True,
        "random_angle": True,
    }
)
