# Copyright (C) king.com Ltd 2025
# License: Apache 2.0

num_rollouts=250;
data_quality="mixture-100percent-expert"
pdt_model_path="$1"
bandit_exploration="ts"
echo "Running prompt tuning with PDT model $pdt_model_path"

baseline_result_files=();
bandit_result_files=();
for target_angle in $(LC_NUMERIC=C seq -f "%.1f" 0.0 0.1 1.5); do
    echo "Target angle: $target_angle"

    pdt_result_file=$(python3 tune_pdt.py \
    --target_angle $target_angle \
    --num_rollouts $num_rollouts \
    --hide_plots \
    --seed 0 \
    --load_path $pdt_model_path \
    --sampling_method "random" \
    --data_mixture $data_quality \
    | tee /dev/tty | tail -n 1)
    baseline_result_files+=("$pdt_result_file\n")
    
    hillclimbing_result_file=$(python3 tune_pdt.py \
    --target_angle $target_angle \
    --num_rollouts $num_rollouts \
    --hide_plots \
    --seed 0 \
    --load_path $pdt_model_path \
    --sampling_method "hillclimbing" \
    --data_mixture $data_quality \
    | tee /dev/tty | tail -n 1)
    baseline_result_files+=("$pdt_result_file\n")
    
    zorank_result_file=$(python3 tune_pdt.py \
    --target_angle $target_angle \
    --num_rollouts $num_rollouts \
    --hide_plots \
    --seed 0 \
    --load_path $pdt_model_path \
    --sampling_method "zoranksgd" \
    --data_mixture $data_quality \
    | tee /dev/tty | tail -n 1)
    baseline_result_files+=("$pdt_result_file\n")

    bandit_result_file=$(python3 tune_pdt.py \
    --target_angle $target_angle \
    --num_rollouts $num_rollouts \
    --hide_plots \
    --seed 0 \
    --load_path $pdt_model_path \
    --sampling_method $bandit_exploration \
    --data_mixture $data_quality \
    | tee /dev/tty | tail -n 1)
    bandit_result_files+=("$bandit_result_file\n")
done



