# Installation
Installation instructions for the [PDT codebase](https://github.com/mxu34/prompt-dt/tree/main) for MuJoCo and Metaworld experiments:
```
conda create --name prompt-dt-mujoco python=3.8.5
conda activate prompt-dt-mujoco
```
 - Install the [mujoco-py repo](https://github.com/openai/mujoco-py).

 - Install environments and dependencies with the following commands:

```
# install dependencies
pip install -r requirements.txt

# install environments
./install_envs.sh
```

## Download Datasets
 - Download the "data" folder: [Google Drive link](https://drive.google.com/drive/folders/1six767uD8yfdgoGIYW86sJY-fmMdYq7e?usp=sharing).

```
wget -O data.zip 'https://drive.google.com/uc?export=download&id=1rZufm-XRq1Ig-56DejkQUX1si_WzCGBe&confirm=True' 
unzip data.zip
rm data.zip
```
 - Organize folders as follows.
```
.
├── config
├── data
│   ├── ant_dir
│   ├── cheetah_dir
│   ├── cheetah_vel
│   └── ML1-pick-place-v2
├── envs
├── prompt_dt
└── ...
```

# Usage
1. Train PDT for target task:
```
python pdt_main.py --env cheetah_vel # choices:['cheetah_vel', 'ant_dir', 'ML1-pick-place-v2']
```
2. Run prompt-tuning:
```
bash ./run_tuning.sh "model_saved/pdt_dir/pdt_checkpoint_file"
```
3. Run CQL
```
bash ./run_cql.sh
```

## Acknowledgement
This PDT code is based on the official repo: https://github.com/mxu34/prompt-dt

The CQL code is based on the official repo: https://github.com/aviralkumar2907/CQL