import matplotlib.pyplot as plt
import os

DIR_PATH = os.path.dirname(os.path.realpath(__file__))
os.chdir(os.path.join(DIR_PATH, "../../"))

# Initialization
steps = []
mean = []
ust = []
lst = []

# data of CombUCB
with open('data2/change_T/CombUCB_sto_64_0.250000_8', 'r') as file:
    for line in file:
        if line.startswith("#"):
            continue
        data = line.strip().split()
        steps.append(int(data[0]))
        mean.append(float(data[1]))
        ust.append(float(data[1]) + float(data[2]) / 2)
        lst.append(float(data[1]) - float(data[2]) / 2)

plt.figure(figsize=(10, 6))
plt.plot(steps, mean, color='red', label='CombUCB1', linewidth=2)
plt.fill_between(steps, ust, lst, color='red', alpha=0.2)

steps = []
mean = []
ust = []
lst = []

# data of SortUCB
with open('data2/change_T/SortUCB_sto_64_0.250000_8', 'r') as file:
    for line in file:
        if line.startswith("#"):
            continue
        data = line.strip().split()
        steps.append(int(data[0]))
        mean.append(float(data[1]))
        ust.append(float(data[1]) + float(data[2]) / 2)
        lst.append(float(data[1]) - float(data[2]) / 2)

plt.plot(steps, mean, color='blue', label='SortUCB', linewidth=2)
plt.fill_between(steps, ust, lst, color='blue', alpha=0.2)

# next dataset
steps = []
mean = []
ust = []
lst = []

# CombUCB1-s
with open('data2/change_T/MPMAB_sto_64_0.250000_8', 'r') as file:
    for line in file:
        if line.startswith("#"):
            continue
        data = line.strip().split()
        steps.append(int(data[0]))
        mean.append(float(data[1]))
        ust.append(float(data[1]) + float(data[2]) / 2)
        lst.append(float(data[1]) - float(data[2]) / 2)

plt.plot(steps, mean, color='green', label='MPMAB-s', linewidth=2)
plt.fill_between(steps, ust, lst, color='green', alpha=0.2)

# next dataset
steps = []
mean = []
ust = []
lst = []

# SortUCB-s
with open('data2/change_T/SortUCBSD_8_8', 'r') as file:
    for line in file:
        if line.startswith("#"):
            continue
        data = line.strip().split()
        steps.append(int(data[0]))
        mean.append(float(data[1]))
        ust.append(float(data[1]) + float(data[2]) / 2)
        lst.append(float(data[1]) - float(data[2]) / 2)

plt.plot(steps, mean, color='orange', label='SortUCB-s', linewidth=2)
plt.fill_between(steps, ust, lst, color='orange', alpha=0.2)

plt.xticks(fontsize=18)
plt.yticks(fontsize=18)

plt.xlabel('t', fontsize=18)
plt.ylabel('Regret', fontsize=18)
plt.legend(fontsize=15, loc='upper left')
plt.grid(True, which='both', linestyle='--', linewidth=0.5)

plt.ticklabel_format(style='sci', axis='x', scilimits=(0,0))
plt.gca().yaxis.get_offset_text().set(size=18) 
plt.ticklabel_format(style='sci', axis='y', scilimits=(0,0))
plt.gca().xaxis.get_offset_text().set(size=18)  

plt.savefig('plot.png', bbox_inches='tight')
plt.show()
