import matplotlib.pyplot as plt
import os
import numpy as np

DIR_PATH = os.path.dirname(os.path.realpath(__file__))
os.chdir(DIR_PATH + "/../")

# steps = np.array([3, 4, 5, 6, 7, 8])
# mean_comb = np.array([1419, 2116, 2992, 4402, 6576, 10332])
# mean_mpmab = np.array([1069, 3222, 5138, 9742, 13964, 20111])
# mean_sort = np.array([603, 1116, 1773, 2384, 2550, 1944])
# mean_sorts = np.array([1247, 1359, 2007, 3759, 5979, 8248])
# variance_comb = np.array([80, 164, 199, 357, 275, 550])
# variance_mpmab = np.array([61, 243, 230, 485, 738, 834])
# variance_sort = np.array([138, 275, 227, 283, 269, 282])
# variance_sorts = np.array([250, 208, 463, 520, 341, 1090])

steps = np.array([4, 5, 6, 7, 8, 9, 10])
mean_comb = np.array([2025, 2285, 2460, 2946, 3237, 3524, 3535])
mean_mpmab = np.array([2592, 3058, 2931, 3074, 3168, 3288, 3478])
mean_sort = np.array([473, 692, 782, 1061, 1384, 1691, 1802])
mean_sorts = np.array([79, 414, 414, 503, 1424, 1561, 1828])
variance_comb = np.array([266, 148, 225, 251, 266, 253, 337])
variance_mpmab = np.array([263, 282, 192, 189, 244, 534, 499])
variance_sort = np.array([107, 114, 184, 252, 255, 344, 208])
variance_sorts = np.array([42, 131, 106, 107, 408, 162, 335])

# steps = np.array([1.000, 1.025, 1.050, 1.075, 1.100, 1.125, 1.150])
# mean_comb = np.array([582, 659, 782, 1071, 1695, 2913, 1773])
# mean_mpmab = np.array([1097, 1360, 1431, 1877, 2613, 5074, 3290])
# mean_sort = np.array([441, 481, 629, 602, 1132, 1298, 836])
# mean_sorts = np.array([1075, 1033, 904, 1031, 1152, 1189, 889])
# variance_comb = np.array([78, 78, 68, 133, 287, 458, 207])
# variance_mpmab = np.array([105, 96, 119, 189, 244, 534, 499])
# variance_sort = np.array([40, 70, 90, 120, 366, 410, 203])
# variance_sorts = np.array([221, 209, 145, 131, 179, 289, 155])

plt.figure(figsize=(10, 6))

plt.plot(steps, mean_comb, color='red', label='CombUCB1')
plt.fill_between(steps, mean_comb - variance_comb/2, mean_comb + variance_comb/2, color='red', alpha=0.2)

plt.plot(steps, mean_sort, color='blue', label='SortUCB')
plt.fill_between(steps, mean_sort - variance_sort/2, mean_sort + variance_sort/2, color='blue', alpha=0.2)

plt.plot(steps, mean_mpmab, color='green', label='MPMAB-s')
plt.fill_between(steps, mean_mpmab - variance_mpmab/2, mean_mpmab + variance_mpmab/2, color='green', alpha=0.2)

plt.plot(steps, mean_sorts, color='orange', label='SortUCB-s')
plt.fill_between(steps, mean_sorts - variance_sorts/2, mean_sorts + variance_sorts/2, color='orange', alpha=0.2)

plt.xticks(fontsize=18)
plt.yticks(fontsize=18)

plt.xlabel('M', fontsize=18)
plt.ylabel('Regret', fontsize=18)
plt.legend(fontsize=15, loc='upper left')
plt.grid(True, which='both', linestyle='--', linewidth=0.5)

plt.ticklabel_format(style='sci', axis='x', scilimits=(0,0))
plt.gca().yaxis.get_offset_text().set(size=18)  
plt.ticklabel_format(style='sci', axis='y', scilimits=(0,0))
plt.gca().xaxis.get_offset_text().set(size=18)  

plt.savefig('plot.png', bbox_inches='tight')
plt.show()
