# Vision ELECTRA
## Installation
Install CUDA 10.1 following the official installation guide of CUDA.

Setup conda environment:
```
# Create environment
conda create -n ve python=3.8 -y
conda activate ve

# Install requirements
conda install pytorch torchvision torchaudio cudatoolkit=10.1 -c pytorch -y

# Install apex
git clone https://github.com/NVIDIA/apex
cd apex
pip install -v --disable-pip-version-check --no-cache-dir --global-option="--cpp_ext" --global-option="--cuda_ext" ./
cd ..

# Install other requirements
pip install -r requirements.txt
```

## Preparing the Official Pre-trained Models
Preparation for Continual Pre-Training:

SimMIM ViT-B donwload link: [click here](https://drive.google.com/file/d/1dJn6GYkwMIcoP3zqOEyW1_iQfpBi8UOw/view?usp=sharing)

MAE ViT-B donwload link: [click here](https://dl.fbaipublicfiles.com/mae/pretrain/mae_pretrain_vit_base.pth)

## Pre-training with Vision Electra
Before starting the pre-training, please fill in the necessary part of the config file.

The name of config file is "vision_electra_mae_vit_base__img224_pretrain.yaml".

```
python -m torch.distributed.launch --nproc_per_node=<gpu_nums> --master_port=<port_num> main_vision_electra.py \
--cfg <config-file> --data-path <imagenet-path>/train [--batch-size <batch-size-per-gpu> --output <output-directory>
```

## Fine-tuning with Discriminator of Vision Electra
Before starting the pre-training, please fill in the necessary part of the config file.

The name of config file is "vision_electra__vit_base__img224_finetune.yaml".

```
python -m torch.distributed.launch --nproc_per_node=<gpu_nums> --master_port=<port_num>  main_finetune.py \ 
--cfg <config-file> --data-path <imagenet-path> --pretrained <pretrained-ckpt> [--batch-size <batch-size-per-gpu> --output <output-directory>
```