from .swin_transformer import build_swin
from .vision_transformer import build_vit
from .vision_transformer_for_visualize import build_vit_visualize
from .simmim import build_simmim
from .vision_electra import build_vision_electra

def build_model(config, is_pretrain=True):
    if is_pretrain:
        generator, discriminator = build_vision_electra(config)
        return generator, discriminator

    else:
        model_type = config.MODEL.TYPE
        if model_type == 'swin':
            model = build_swin(config)
        elif model_type == 'vit':
            model = build_vit(config)
        else:
            raise NotImplementedError(f"Unknown fine-tune model: {model_type}")

        return model
