(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      8323,        254]
NotebookOptionsPosition[      7310,        228]
NotebookOutlinePosition[      7708,        244]
CellTagsIndexPosition[      7665,        241]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"$Assumptions", "=", 
  RowBox[{
   RowBox[{"\[Sigma]", ">", "0"}], "&&", 
   RowBox[{"c", ">", "0"}], "&&", 
   RowBox[{"m", ">", "4"}], "&&", 
   RowBox[{"nstar", ">", "0"}], "&&", 
   RowBox[{"\[Alpha]", ">", "0"}]}]}]], "Input",
 CellChangeTimes->{{3.8937213688289137`*^9, 3.89372137489277*^9}, {
   3.8937214319180346`*^9, 3.8937214379838395`*^9}, 3.893721486956652*^9},
 CellLabel->"In[8]:=",ExpressionUUID->"b0dd9894-3eec-4c84-86ba-859fd04fa755"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Sigma]", ">", "0"}], "&&", 
  RowBox[{"c", ">", "0"}], "&&", 
  RowBox[{"m", ">", "4"}], "&&", 
  RowBox[{"nstar", ">", "0"}], "&&", 
  RowBox[{"\[Alpha]", ">", "0"}]}]], "Output",
 CellChangeTimes->{{3.8937214787871103`*^9, 3.8937214902128277`*^9}},
 CellLabel->"Out[8]=",ExpressionUUID->"05444e64-8776-4c10-b02b-43337bb6e53b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "[", "ni_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    FractionBox[
     SuperscriptBox["\[Sigma]", "2"], 
     RowBox[{"Sqrt", "[", 
      RowBox[{"2", "\[Pi]"}], "]"}]], 
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
     RowBox[{
      FractionBox[
       RowBox[{"Exp", "[", 
        RowBox[{"-", 
         FractionBox[
          SuperscriptBox["x", "2"], "2"]}], "]"}], 
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{"(", 
           RowBox[{"m", "-", "2"}], ")"}], "nstar"}], 
         RowBox[{"1", "+", 
          RowBox[{
           SuperscriptBox["\[Alpha]", "2"], 
           RowBox[{"(", 
            RowBox[{
             FractionBox["1", "ni"], "+", 
             FractionBox["1", "nstar"]}], ")"}], 
           SuperscriptBox["x", "2"]}]}]], "+", "ni", "+", "nstar"}]], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}], "+", 
   RowBox[{"c", " ", "ni"}]}]}]], "Input",
 CellChangeTimes->{{3.8937214110259304`*^9, 3.893721422001512*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"93fe0a9d-3bf9-48e9-8686-77eabc96c1fc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"p", "'"}], "[", "nstar", "]"}], "]"}]], "Input",
 CellChangeTimes->{3.8937214497603855`*^9},
 CellLabel->"In[10]:=",ExpressionUUID->"03d83482-af49-4151-bd97-409171585984"],

Cell[BoxData[
 RowBox[{"c", "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"32", " ", 
     SuperscriptBox["m", "2"], " ", 
     SuperscriptBox["nstar", "2"], " ", 
     SqrtBox[
      RowBox[{"2", " ", "\[Pi]"}]], " ", 
     SuperscriptBox["\[Alpha]", "3"]}]], 
   RowBox[{
    SuperscriptBox["\[Sigma]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "m", " ", 
       SqrtBox[
        RowBox[{"2", " ", "\[Pi]"}]], " ", "\[Alpha]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", "m"}], ")"}], " ", "nstar"}], "-", 
         RowBox[{"4", " ", "m", " ", 
          SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"m", " ", "nstar"}], 
         RowBox[{"8", " ", 
          SuperscriptBox["\[Alpha]", "2"]}]]], " ", "\[Pi]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"m", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"m", " ", "nstar"}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], "+", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{"m", " ", "nstar"}]]}], "-", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["m", "5"], " ", "nstar"}]]}], ")"}], " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "-", 
         RowBox[{"2", " ", "m", " ", 
          SqrtBox[
           RowBox[{"m", " ", "nstar"}]], " ", 
          RowBox[{"(", 
           RowBox[{"nstar", "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        FractionBox[
         RowBox[{"m", " ", "nstar"}], 
         RowBox[{"8", " ", 
          SuperscriptBox["\[Alpha]", "2"]}]]], " ", "\[Pi]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"m", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"m", " ", "nstar"}], ")"}], 
           RowBox[{"3", "/", "2"}]]}], "+", 
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SqrtBox[
              RowBox[{"m", " ", "nstar"}]]}], "-", 
            SqrtBox[
             RowBox[{
              SuperscriptBox["m", "5"], " ", "nstar"}]]}], ")"}], " ", 
          SuperscriptBox["\[Alpha]", "2"]}], "-", 
         RowBox[{"2", " ", "m", " ", 
          SqrtBox[
           RowBox[{"m", " ", "nstar"}]], " ", 
          RowBox[{"(", 
           RowBox[{"nstar", "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["\[Alpha]", "2"]}]}], ")"}]}]}], ")"}], " ", 
       RowBox[{"Erf", "[", 
        FractionBox[
         SqrtBox[
          RowBox[{"m", " ", "nstar"}]], 
         RowBox[{"2", " ", 
          SqrtBox["2"], " ", "\[Alpha]"}]], "]"}]}]}], ")"}]}]}]}]], "Output",
 CellChangeTimes->{3.8937226559814425`*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"f8e3e267-ee5e-4275-8219-a3066f9146ef"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"p", "[", "nstar", "]"}], "]"}]], "Input",
 CellChangeTimes->{3.8937214550474443`*^9},
 CellLabel->"In[11]:=",ExpressionUUID->"6eccafb3-68a9-4954-9e97-ef73eac63efa"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "8"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"8", " ", "c", " ", "nstar"}], "+", 
    FractionBox[
     RowBox[{"4", " ", 
      SuperscriptBox["\[Sigma]", "2"]}], "nstar"], "-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       FractionBox[
        RowBox[{"m", " ", "nstar"}], 
        RowBox[{"8", " ", 
         SuperscriptBox["\[Alpha]", "2"]}]]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "m"}], ")"}], " ", 
      SqrtBox[
       RowBox[{"2", " ", "\[Pi]"}]], " ", 
      SuperscriptBox["\[Sigma]", "2"], " ", 
      RowBox[{"Erfc", "[", 
       FractionBox[
        SqrtBox[
         RowBox[{"m", " ", "nstar"}]], 
        RowBox[{"2", " ", 
         SqrtBox["2"], " ", "\[Alpha]"}]], "]"}]}], 
     RowBox[{
      SqrtBox[
       RowBox[{"m", " ", "nstar"}]], " ", "\[Alpha]"}]]}], ")"}]}]], "Output",
 CellChangeTimes->{3.893722657982137*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"d8e94f44-b381-41a6-aafd-618a84cf3805"]
}, Open  ]]
},
WindowSize->{1144, 1348},
WindowMargins->{{-7, Automatic}, {Automatic, 0}},
FrontEndVersion->"12.3 for Microsoft Windows (64-bit) (July 9, 2021)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"a5d4b779-098d-41b4-af68-388052a997a4"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 476, 10, 29, "Input",ExpressionUUID->"b0dd9894-3eec-4c84-86ba-859fd04fa755"],
Cell[1059, 34, 365, 8, 33, "Output",ExpressionUUID->"05444e64-8776-4c10-b02b-43337bb6e53b"]
}, Open  ]],
Cell[1439, 45, 1149, 34, 77, "Input",ExpressionUUID->"93fe0a9d-3bf9-48e9-8686-77eabc96c1fc"],
Cell[CellGroupData[{
Cell[2613, 83, 235, 5, 29, "Input",ExpressionUUID->"03d83482-af49-4151-bd97-409171585984"],
Cell[2851, 90, 3143, 92, 107, "Output",ExpressionUUID->"f8e3e267-ee5e-4275-8219-a3066f9146ef"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6031, 187, 216, 4, 29, "Input",ExpressionUUID->"6eccafb3-68a9-4954-9e97-ef73eac63efa"],
Cell[6250, 193, 1044, 32, 114, "Output",ExpressionUUID->"d8e94f44-b381-41a6-aafd-618a84cf3805"]
}, Open  ]]
}
]
*)

