import numpy as np
from scipy import special
import matplotlib.pyplot as plt

from scipy.optimize import fsolve
import pandas as pd

def G(A,m):
	# calculate G x Sqrt(m) as a function of A and m 
	# multiply by Sqrt(m) to reduce numerical error
	A1 = (4*(A**2)* (m-4)/(m-2) - 1)*4*A
	A2 = np.sqrt(m)*(4*(m+1)*(A**2)/m-1)*np.sqrt(2*np.pi) \
			* np.exp(m/(8*(A**2))) * special.erfc(np.sqrt(m)/(2*np.sqrt(2)*A))

	return A1 - A2

def E(A,m):
	A2 = A*A
	num = 4 * A2 * ((A2-1) * m + 1 - 4 * A2) * m
	den	= (4 * A2 + m) * ((7*A2 - 1) * m + 2 * A2)

	return num / den

def Cm(m):
	if m <= 20:
		return 20
	else:
		return 5

M = 500
m_range = range(5,M)
Am = np.zeros(len(m_range))
Em = np.zeros(len(m_range))
UB = [5/i for i in m_range]
Gm = [G(1+Cm(m)/m,m)/np.sqrt(m) for m in m_range]

for i in range(len(m_range)):
	m = m_range[i]
	if m <= 20:
		init = 1+20/m
	else:
		init = 1+5/m
	Am[i] = fsolve(lambda x: G(x,m), init)

	Em[i] = E(Am[i],m)

plt.rcParams['text.usetex'] = True


plt.subplots(figsize=(6, 2))

plt.axvline(x=5,alpha=0.2)
plt.axvline(x=20,alpha=0.2)
plt.scatter(m_range,Gm,s=1,label=r'$G\left((1+C_m/m)\sqrt{n^*}\right)$')

plt.text(-2,1e-5,'m=5',rotation=90)
plt.text(14,5e-2,'m=20',rotation=90)
plt.xlabel('m')
plt.legend()
plt.yscale('log')

plt.savefig('Gfunc.pdf')

plt.subplots(figsize=(6, 2))

plt.axvline(x=5,alpha=0.2)
plt.scatter(m_range,UB,s=1,label='5/m')
plt.scatter(m_range,Em,s=1,label='E(m)')

plt.text(6,0.01,'m=5',rotation=0)
plt.xlabel('m')
plt.legend()
plt.yscale('log')

plt.savefig('efuncUB.pdf')
