# 🎯 SPORT: Iterative Tool Usage Exploration for Multimodal Agents via Step-wise Preference Tuning


SPORT introduces an online self-exploration loop that enables multimodal agents to self-improve via AI-generated tasks and LLM-verified preference tuning without human annotations.

## 📋 Key Features

- **Task Synthesis**: Automatically generates multimodal tasks using language models
- **Step Sampling**: Proposes and executes multiple candidate actions at each decision point
- **Step Verification**: Uses LLM as a critic to compare and rank action outcomes
- **Preference Tuning**: Updates agent policy through preference-based optimization

## 📋 Project Structure

The project consists of several main components:
- 📊 `data_generation/`: Contains the data generation pipeline
- ✅ `closed_loop_verifier/`: Verification and validation tools
- 🤖 `sport_agent/`: Core agent implementation
- 🔧 `script/`: Utility scripts

## 🚀 Quick Start

### Installation
```bash
pip install -r requirements.txt
```

### Environment Setup
The project uses environment variables for configuration. Make sure to set up your `.env` file and `configs/agent_config.yaml` with the necessary credentials and settings.
