import string
import shortuuid
import os
from typing import Union

from omegaconf import OmegaConf, DictConfig, ListConfig

CACHE_FOLDER = ".cache"
os.makedirs(CACHE_FOLDER, exist_ok=True)

def get_uuid_builder() -> shortuuid.ShortUUID:
    alphabet = string.ascii_lowercase + string.digits
    su = shortuuid.ShortUUID(alphabet=alphabet)
    return su

def load_config() -> Union[DictConfig, ListConfig]:
    if "AGENT_CONFIG" in os.environ and len(os.environ["AGENT_CONFIG"]) > 0:
        return OmegaConf.load(os.environ["AGENT_CONFIG"])  
    if "RUN_MODE" in os.environ and os.environ["RUN_MODE"] == "eval":
        return OmegaConf.load("configs/agent_config.yaml")
    return OmegaConf.load("configs/agent_config_qwen.yaml")

import time
uuid_builder = get_uuid_builder()

def gen_random_id():
    return f"{int(time.time()*1000)}_{uuid_builder.random(length=8)}"    

import logging
from logging import handlers

class Logger(object):
    level_relations = {
        'debug':logging.DEBUG,
        'info':logging.INFO,
        'warning':logging.WARNING,
        'error':logging.ERROR,
        'crit':logging.CRITICAL
    }

    def __init__(self,filename,level='info',when='D',backCount=3,fmt='%(asctime)s - %(pathname)s[line:%(lineno)d] - %(levelname)s: %(message)s'):
        self.logger = logging.getLogger(filename)
        format_str = logging.Formatter(fmt)
        self.logger.setLevel(self.level_relations.get(level))
        sh = logging.StreamHandler()
        sh.setFormatter(format_str) 
        th = handlers.TimedRotatingFileHandler(filename=filename,when=when,backupCount=backCount,encoding='utf-8')
        
        th.setFormatter(format_str)
        self.logger.addHandler(sh) 
        self.logger.addHandler(th)
if __name__ == '__main__':
    log = Logger('.cache/1734937977506_7pnsve84/dpo_agent.log',level='debug')
    log.logger.debug('debug')
    log.logger.info('info')
    log.logger.warning('warning')
    log.logger.error('error')
    log.logger.critical('critical')
    Logger('error.log', level='error').logger.error('error')

