/*
 * Decompiled with CFR 0.152.
 */
package datagen;

import datagen.Example;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EvaluateRegex {
    private static final Map<String, String> parseTerminals;

    public boolean evaluateEmpty(String regex) {
        for (String k : parseTerminals.keySet()) {
            if (!regex.contains(k)) continue;
            regex = regex.replace(k, parseTerminals.get(k));
        }
        Automaton r = new RegExp(regex).toAutomaton(false);
        return r.isEmpty();
    }

    public boolean evaluate_positive(String regex, String example) {
        Automaton r = new RegExp(regex).toAutomaton(false);
        return r.run(example);
    }

    public boolean evaluate(String regex, List<Example> examples) {
        for (String k : parseTerminals.keySet()) {
            if (!regex.contains(k)) continue;
            regex = regex.replace(k, parseTerminals.get(k));
        }
        Automaton r = new RegExp(regex).toAutomaton(false);
        for (Example e : examples) {
            if (!(r.run(e.input) ? !e.output : e.output)) continue;
            return false;
        }
        return true;
    }

    public boolean checkEquavalence(String gt, String in) {
        for (String k : parseTerminals.keySet()) {
            if (!gt.contains(k)) continue;
            gt = gt.replace(k, parseTerminals.get(k));
        }
        for (String k : parseTerminals.keySet()) {
            if (!in.contains(k)) continue;
            in = in.replace(k, parseTerminals.get(k));
        }
        Automaton g = new RegExp(gt).toAutomaton(true);
        Automaton i = new RegExp(in).toAutomaton(true);
        return g.equals(i);
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("<vow>", "[AEIOUaeiou]");
        map.put("<let>", "[A-Za-z]");
        map.put("<low>", "[a-z]");
        map.put("<cap>", "[A-Z]");
        map.put("<num>", "[0-9]");
        map.put("<any>", ".");
        map.put("<m0>", "[!]");
        map.put("<m1>", "[@]");
        map.put("<m2>", "[#]");
        map.put("<m3>", "[$]");
        parseTerminals = Collections.unmodifiableMap(map);
    }
}

