/*
 * Decompiled with CFR 0.152.
 */
package datagen;

import datagen.Main;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ExampleGenerator {
    private static final Map<String, String> parseTerminals;

    private void generate_examples(String regex, Set<String> examples, String mode, int index) {
        Automaton a = new RegExp(regex).toAutomaton(true);
        if (a.isEmpty()) {
            if (mode.equals("+")) {
                Main.noexample_empty.add(index);
            }
            return;
        }
        int min_length = a.getShortestExample(true).length();
        int example_count = 0;
        int curr_length = min_length;
        while (example_count < Main.exampleNum && curr_length <= Main.length_max) {
            Automaton tmp = a.clone();
            Set<String> exampleSet = tmp.getStrings(curr_length, Main.limit);
            if (exampleSet == null || exampleSet.isEmpty()) {
                ++curr_length;
                continue;
            }
            for (String s : exampleSet) {
                examples.add("\"" + s + "\"," + mode);
                ++example_count;
            }
            ++curr_length;
        }
        if (examples.size() == 0) {
            Main.noexample_error.add(index);
            System.out.println("No example for regex: " + regex);
        }
    }

    public Set<String> generate(String regex, int index) {
        HashSet<String> examples = new HashSet<String>();
        String regexCheckEmpty = regex;
        for (String string : parseTerminals.keySet()) {
            if (string.equals("<any>")) {
                regexCheckEmpty = regexCheckEmpty.replace(string, ".");
                continue;
            }
            if (string.equals(".") || !regexCheckEmpty.contains(string)) continue;
            regexCheckEmpty = regexCheckEmpty.replace(string, parseTerminals.get(string));
        }
        Automaton a = new RegExp(regexCheckEmpty).toAutomaton(true);
        if (a.isEmpty()) {
            System.out.println("empty regex");
            Main.noexample_empty.add(index);
            examples.add("null");
            return examples;
        }
        for (String k : parseTerminals.keySet()) {
            if (!regex.contains(k)) continue;
            regex = regex.replace(k, parseTerminals.get(k));
        }
        if (regex.contains("\\b")) {
            regex = regex.replace("\\b", "");
        }
        this.generate_examples(regex, examples, "+", index);
        if (examples.size() == 0) {
            examples.add("null");
            return examples;
        }
        String string = "~(" + regex + ")";
        this.generate_examples(string, examples, "-", index);
        return examples;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("<vow>", "[AEIOUaeiou]");
        map.put("<let>", "[A-Za-z]");
        map.put("<low>", "[a-z]");
        map.put("<cap>", "[A-Z]");
        map.put("<num>", "[0-9]");
        map.put("<any>", "[!-~]");
        map.put("<m0>", "[!]");
        map.put("<m1>", "[@]");
        map.put("<m2>", "[#]");
        map.put("<m3>", "[$]");
        parseTerminals = Collections.unmodifiableMap(map);
    }
}

