/*
 * Decompiled with CFR 0.152.
 */
package datagen;

import datagen.BenchmarkPair;
import datagen.DataGenerator;
import datagen.DrDataGenerator;
import datagen.EvaluateRegex;
import datagen.Example;
import datagen.ExampleGenerator;
import datagen.Kb13DataGenerator;
import datagen.PoplDataGenerator;
import datagen.SketchGenerator;
import datagen.SoDataGenerator;
import datagen.spec.SpecLang;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Main {
    public static String dataPath = "";
    public static String drPath = "/Users/lycoris/Google Drive/Code/resnax/exp/deepregex";
    public static String kb13Path = "/Users/lycoris/Google Drive/Code/resnax/exp";
    public static String poplPath = "";
    public static String inputTargPath = "data/synth/targ-train.txt";
    public static String inputSpecPath = "data/synth/spec-train.txt";
    public static String inputSketchPath = "data/synth/sketch-train/";
    public static String outputTokenizeDSLPath = "data/synth/tokenize_dsl/spec-train.txt";
    public static String outputTokenizeSketchPath = "data/synth/tokenize_sketch/spec-train.txt";
    public static String outputExamplePath = "data/synth/example-train";
    public static String prediceDirName = "log-beam/";
    public static String mode;
    public static int tokenize;
    public static int transformTarg;
    public static int holeDepth;
    public static int exampleNum;
    public static int example_per_iter;
    public static int length_min;
    public static int length_max;
    public static int limit;
    public static int transitionVisitLimit;
    public static List<Integer> noexample_empty;
    public static List<Integer> noexample_error;
    private static final Map<String, String> parseTerminals;

    private static void call_run_data(Main main, String dataset, String data, String type) {
        if (dataset.equals("dr") && data.contains("popl")) {
            main.run_data(new PoplDataGenerator(), Main.getTargPath(data, type), Main.getTokenizeDSLPath(data, type));
        } else if (dataset.equals("dr")) {
            main.run_data(new DrDataGenerator(), Main.getTargPath(data, type), Main.getTokenizeDSLPath(data, type));
        } else if (dataset.equals("kb13")) {
            main.run_data(new Kb13DataGenerator(), Main.getTargPath(data, type), Main.getTokenizeDSLPath(data, type));
        }
    }

    public static void main(String[] args) {
        String type;
        Main main = new Main();
        if (args[0].equals("example")) {
            mode = args[0];
            exampleNum = Integer.parseInt(args[1]);
            System.out.println(main.run_example_single(args[2]));
            return;
        }
        if (args[0].equals("evaluate")) {
            mode = args[0];
            System.out.println(main.run_evaluate(args[1], args[2]));
            return;
        }
        if (args[0].equals("equiv")) {
            mode = args[0];
            System.out.println(main.run_equiv(args[1], args[2]));
            return;
        }
        if (args[0].equals("evaluate_single")) {
            mode = args[0];
            boolean flag_force = args[4].equals("true");
            System.out.println(main.run_evaluate_single(args[1], args[2], args[3], flag_force));
            return;
        }
        if (args[0].equals("evaluate_single_file")) {
            mode = args[0];
            boolean flag_force = args[2].equals("true");
            String file_name = args[1];
            List<String> all_lines = null;
            try {
                all_lines = Files.readAllLines(Paths.get(file_name, new String[0]));
            }
            catch (IOException e) {
                System.out.println("NOSUCHFILE");
            }
            System.out.println(main.run_evaluate_single(all_lines.get(0), all_lines.get(1), all_lines.get(2), flag_force));
            return;
        }
        if (args[0].equals("preverify")) {
            mode = args[0];
            System.out.println(main.run_preverify(args[1], args[2]));
            return;
        }
        if (args[0].equals("preverify_file")) {
            mode = args[0];
            String file_name = args[1];
            List<String> all_lines = null;
            try {
                all_lines = Files.readAllLines(Paths.get(file_name, new String[0]));
            }
            catch (IOException e) {
                System.out.println("NOSUCHFILE");
            }
            System.out.println(main.run_preverify(all_lines.get(0), all_lines.get(1)));
            return;
        }
        if (args[0].equals("popl")) {
            String popl_input = "";
            String popl_output = "";
            String popl_dir = "";
            main.run_popl(popl_input, popl_output, popl_dir);
            return;
        }
        String data = args.length >= 2 ? args[2] : null;
        String string = type = args.length >= 3 ? args[3] : null;
        if (data != null && data.equals("popl")) {
            dataPath = poplPath;
        }
        if (args[0].equals("dr")) {
            dataPath = drPath;
        }
        if (args[0].equals("kb13")) {
            dataPath = kb13Path;
        }
        if (args[1].equals("tokenizeDSL")) {
            tokenize = 1;
            mode = args[1];
            Main.call_run_data(main, args[0], data, type);
        }
        if (args[1].equals("data")) {
            mode = args[1];
            Main.call_run_data(main, args[0], data, type);
        }
        if (args[1].equals("transformTarg")) {
            mode = args[1];
            transformTarg = 1;
            Main.call_run_data(main, args[0], data, type);
        }
        if (args[1].equals("sketch")) {
            mode = args[1];
            main.run_sketch(Main.getSpecPath(data, type), Main.getSketchPath(data, type));
        }
        if (args[1].equals("tokenizeSketch")) {
            mode = args[1];
            tokenize = 1;
            main.run_tokenizeSketch(Main.getSpecPath(data, type), Main.getTokenizeSketchPath(data, type));
        }
        if (args[1].equals("example")) {
            mode = args[1];
            if (args.length >= 5) {
                transitionVisitLimit = Integer.valueOf(args[4]);
            }
            main.run_example(Main.getTargPath(data, type), Main.getSpecPath(data, type), Main.getExamplePath(data, type));
        }
        if (args[1].equals("misc")) {
            mode = "";
            String readTargPath = Main.getTargPath(data, type);
            String readSpecPath = Main.getSpecPath(data, type);
            mode = args[1];
            main.run_misc(readTargPath, readSpecPath, Main.getTargPath(data, type), Main.getSpecPath(data, type));
        }
        if (args[1].equals("filter")) {
            mode = args[1];
            if (args[0].equals("dr") && data.contains("popl")) {
                main.run_filter(new PoplDataGenerator(), Main.getExamplePath(data, type), Main.getPredictPath(data, type));
            } else if (args[0].equals("dr")) {
                main.run_filter(new DrDataGenerator(), Main.getExamplePath(data, type), Main.getPredictPath(data, type));
            } else if (args[0].equals("kb13")) {
                main.run_filter(new Kb13DataGenerator(), Main.getExamplePath(data, type), Main.getPredictPath(data, type));
            }
        }
        if (args[1].equals("syntax")) {
            mode = args[1];
            if (args[0].equals("dr") && data.contains("popl")) {
                main.run_syntax(new PoplDataGenerator(), Main.getPredictPath(data, type));
            } else if (args[0].equals("dr")) {
                main.run_syntax(new DrDataGenerator(), Main.getPredictPath(data, type));
            } else if (args[0].equals("kb13")) {
                main.run_syntax(new Kb13DataGenerator(), Main.getPredictPath(data, type));
            }
        }
    }

    public static String getTargPath(String data, String type) {
        if (data == null || type == null) {
            return inputTargPath;
        }
        if (mode.equals("example") || mode.equals("misc")) {
            return dataPath + "/" + data + "/example-tmp/targ-" + type + ".txt";
        }
        return dataPath + "/" + data + "/targ-" + type + ".txt";
    }

    public static String getSpecPath(String data, String type) {
        if (data == null || type == null) {
            return inputSpecPath;
        }
        if (mode.equals("example") || mode.equals("misc")) {
            return dataPath + "/" + data + "/example-tmp/spec-" + type + ".txt";
        }
        return dataPath + "/" + data + "/spec-" + type + ".txt";
    }

    public static String getSketchPath(String data, String type) {
        if (data == null || type == null) {
            return inputSketchPath;
        }
        return dataPath + "/" + data + "/sketch-" + type + "/";
    }

    public static String getTokenizeDSLPath(String data, String type) {
        if (data == null || type == null) {
            return outputTokenizeDSLPath;
        }
        return dataPath + "/" + data + "/tokenize_dsl/spec-" + type + ".txt";
    }

    public static String getTokenizeSketchPath(String data, String type) {
        if (data == null || type == null) {
            return outputTokenizeSketchPath;
        }
        return dataPath + "/" + data + "/tokenize_sketch/sketch-" + type + ".txt";
    }

    public static String getExamplePath(String data, String type) {
        if (data == null || type == null) {
            return outputExamplePath;
        }
        return dataPath + "/" + data + "/example-" + type;
    }

    public static String getPredictPath(String data, String type) {
        if (data == null || type == null) {
            throw new RuntimeException();
        }
        return dataPath + "/" + data + "/predict-" + type;
    }

    public String run_evaluate(String spec, String example) {
        try {
            SoDataGenerator so_gen = new SoDataGenerator();
            String regex = so_gen.generate(spec).toRegex();
            EvaluateRegex er = new EvaluateRegex();
            return er.evaluate_positive(regex, example) + "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "wrong";
        }
    }

    public String run_preverify(String predicts_line, String examples_line) {
        SoDataGenerator so_gen = new SoDataGenerator();
        EvaluateRegex er = new EvaluateRegex();
        String[] predicts = predicts_line.split("\t");
        ArrayList<String> over_predicts = new ArrayList<String>();
        ArrayList<String> under_predicts = new ArrayList<String>();
        for (String string : predicts) {
            String[] segs = string.split(" ");
            over_predicts.add(segs[0]);
            under_predicts.add(segs[1]);
        }
        String[] examples_segment = examples_line.split(" ");
        ArrayList<String> pos_exs = new ArrayList<String>();
        ArrayList<String> neg_exs = new ArrayList<String>();
        for (String seg : examples_segment) {
            String sign = seg.substring(0, 1);
            if (sign.equals("+")) {
                pos_exs.add(seg.substring(2));
                continue;
            }
            neg_exs.add(seg.substring(2));
        }
        int n = over_predicts.size();
        ArrayList<String> res_each_pair = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            String op = (String)over_predicts.get(i);
            String oregex = "";
            try {
                oregex = so_gen.generate(op).toRegex();
            }
            catch (Exception e) {
                res_each_pair.add("wrong");
                continue;
            }
            String up = (String)under_predicts.get(i);
            String uregex = "";
            try {
                uregex = so_gen.generate(up).toRegex();
            }
            catch (Exception e) {
                res_each_pair.add("wrong");
                continue;
            }
            int m = 0;
            for (m = 0; m < pos_exs.size(); ++m) {
                String exs = (String)pos_exs.get(m);
                try {
                    String match_output = er.evaluate_positive(oregex, exs) + "";
                    if (match_output.equals("true")) continue;
                }
                catch (Exception e) {}
                break;
            }
            if (m < pos_exs.size()) {
                res_each_pair.add("false");
                continue;
            }
            int n2 = 0;
            for (n2 = 0; n2 < neg_exs.size(); ++n2) {
                String exs = (String)neg_exs.get(n2);
                try {
                    String match_output = er.evaluate_positive(uregex, exs) + "";
                    if (match_output.equals("false")) continue;
                }
                catch (Exception e) {}
                break;
            }
            if (n2 < neg_exs.size()) {
                res_each_pair.add("false");
                continue;
            }
            res_each_pair.add("true");
        }
        return String.join((CharSequence)" ", res_each_pair);
    }

    public String run_evaluate_single(String predicts_line, String examples_line, String gt_spec, boolean flag_force) {
        SoDataGenerator so_gen = new SoDataGenerator();
        String[] predicts = predicts_line.split(" ");
        String[] examples_segment = examples_line.split(" ");
        ArrayList<String> desired_results = new ArrayList<String>();
        ArrayList<String> examples = new ArrayList<String>();
        for (String seg : examples_segment) {
            String sign = seg.substring(0, 1);
            if (sign.equals("+")) {
                desired_results.add("true");
            } else {
                desired_results.add("false");
            }
            examples.add(seg.substring(2));
        }
        String gt_regex = "";
        try {
            gt_regex = so_gen.generate(gt_spec).toRegex();
        }
        catch (Exception e) {
            return "invalid invalid";
        }
        EvaluateRegex er = new EvaluateRegex();
        String global_result = "";
        ArrayList<String> res_each_predict = new ArrayList<String>();
        for (String predict : predicts) {
            if (predict.equals(gt_spec)) {
                res_each_predict.add("exact");
                if (!flag_force) break;
                continue;
            }
            String predict_regex = "";
            try {
                predict_regex = so_gen.generate(predict).toRegex();
            }
            catch (Exception e) {
                res_each_predict.add("invalid");
                continue;
            }
            boolean flag_match_all_exs = true;
            for (int i = 0; i < examples.size(); ++i) {
                String exs = (String)examples.get(i);
                String sign = (String)desired_results.get(i);
                String match_output = "wrong";
                try {
                    match_output = er.evaluate_positive(predict_regex, exs) + "";
                }
                catch (Exception e) {
                    match_output = "wrong";
                }
                if (match_output.equals("wrong")) {
                    res_each_predict.add("invalid");
                    flag_match_all_exs = false;
                    break;
                }
                if (match_output.equals(sign)) continue;
                res_each_predict.add("nonmatch");
                flag_match_all_exs = false;
                break;
            }
            if (!flag_match_all_exs) continue;
            String equiv_out = "wrong";
            try {
                equiv_out = er.checkEquavalence(gt_regex, predict_regex) + "";
            }
            catch (Exception e) {
                equiv_out = "wrong";
            }
            String equiv_result = "";
            equiv_result = equiv_out.equals("true") ? "equiv" : "unequiv";
            res_each_predict.add(equiv_result);
            if (!flag_force) break;
        }
        global_result = "invalid";
        for (String r : res_each_predict) {
            if (r.equals("nonmatch")) {
                global_result = "nonmatch";
            }
            if (r.equals("exact")) {
                global_result = "exact";
                break;
            }
            if (r.equals("equiv")) {
                global_result = "equiv";
                break;
            }
            if (!r.equals("unequiv")) continue;
            global_result = "unequiv";
            break;
        }
        res_each_predict.add(0, global_result);
        return String.join((CharSequence)" ", res_each_predict);
    }

    public String run_equiv(String spec1, String spec2) {
        SoDataGenerator so_gen = new SoDataGenerator();
        try {
            String regex1 = so_gen.generate(spec1).toRegex();
            String regex2 = so_gen.generate(spec2).toRegex();
            EvaluateRegex er = new EvaluateRegex();
            return er.checkEquavalence(regex1, regex2) + "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "wrong";
        }
    }

    public void run_syntax(DataGenerator gen, String prediceDir) {
        int top_1_error = 0;
        int top_1_total = 0;
        int error = 0;
        int total = 0;
        File predictFold = new File(prediceDir);
        assert (predictFold != null);
        block13: for (File f : predictFold.listFiles()) {
            if (f.getName().startsWith(".")) continue;
            try (BufferedReader br = new BufferedReader(new FileReader(new File(f.getAbsolutePath())));){
                boolean first = true;
                String regex = br.readLine();
                while (regex != null) {
                    BenchmarkPair ins = this.process_line(regex);
                    regex = ins.instance;
                    for (String k : parseTerminals.keySet()) {
                        if (!regex.contains(k)) continue;
                        regex = regex.replace(k, parseTerminals.get(k));
                    }
                    try {
                        gen.generate(regex);
                    }
                    catch (Exception e) {
                        if (first) {
                            ++top_1_error;
                            ++top_1_total;
                            first = false;
                        }
                        ++error;
                        ++total;
                        regex = br.readLine();
                        if (regex == null) continue block13;
                        if (!regex.isEmpty()) continue;
                        continue block13;
                    }
                    if (first) {
                        ++top_1_total;
                        first = false;
                    }
                    ++total;
                    regex = br.readLine();
                    if (regex == null) continue block13;
                    if (!regex.isEmpty()) continue;
                    continue block13;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println(top_1_error);
        System.out.println(top_1_total);
        System.out.println(error);
        System.out.println(total);
        System.out.println("top 1 syntax error rate: " + (double)top_1_error / (double)top_1_total);
        System.out.println("overall syntax error rate: " + (double)error / (double)total);
    }

    public void run_filter(DataGenerator gen, String examplePath, String predictDir) {
        int match_example = 0;
        int match_gt = 0;
        int total = 0;
        ArrayList<Integer> acccurateRank = new ArrayList<Integer>();
        ArrayList<Integer> accurateIndex = new ArrayList<Integer>();
        File predictFold = new File(predictDir);
        assert (predictFold != null);
        for (File f : predictFold.listFiles()) {
            if (f.getName().startsWith(".")) continue;
            int index = Integer.valueOf(f.getName());
            BenchmarkPair bp = this.readExample(f.getName(), examplePath + "/" + index);
            if (bp.gt == null || bp.gt.isEmpty() || bp.gt.equals("")) {
                ++match_example;
                ++match_gt;
                ++total;
                continue;
            }
            EvaluateRegex er = new EvaluateRegex();
            SketchGenerator skGen = new SketchGenerator();
            try (BufferedReader br = new BufferedReader(new FileReader(new File(f.getAbsolutePath())));){
                boolean res = false;
                String regex = br.readLine();
                while (regex != null) {
                    BenchmarkPair ins = this.process_line(regex);
                    regex = ins.instance;
                    for (String k : parseTerminals.keySet()) {
                        if (!regex.contains(k)) continue;
                        regex = regex.replace(k, parseTerminals.get(k));
                    }
                    SpecLang.Symbol spec = null;
                    try {
                        spec = gen.generate(regex);
                    }
                    catch (Exception e) {
                        regex = br.readLine();
                        if (regex != null) {
                            if (!regex.isEmpty()) continue;
                        }
                        break;
                    }
                    res = er.evaluate(spec.toRegex(), bp.examples);
                    if (res) {
                        ++match_example;
                        SpecLang.Symbol gtSpec = skGen.generate(bp.gt);
                        if (er.checkEquavalence(gtSpec.toRegex(), spec.toRegex())) {
                            acccurateRank.add(ins.index);
                            accurateIndex.add(index);
                            ++match_gt;
                        }
                    } else {
                        regex = br.readLine();
                        if (regex != null) {
                            if (!regex.isEmpty()) continue;
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++total;
        }
        System.out.println("accuracy:" + match_example);
        System.out.println("accuracy:" + match_gt);
        System.out.println(total);
        System.out.println(acccurateRank);
        System.out.println(accurateIndex);
    }

    public BenchmarkPair readExample(String index, String path) {
        ArrayList<Example> examples = new ArrayList<Example>();
        String gt = "";
        try (BufferedReader br = new BufferedReader(new FileReader(new File(path)));){
            String line = br.readLine();
            while (line.isEmpty() || line.startsWith("//")) {
                line = br.readLine();
            }
            while (line != null && !line.isEmpty()) {
                if (!line.startsWith("//")) {
                    if (line.contains("null")) break;
                    int splitIndex = line.lastIndexOf(44);
                    String str = line.substring(1, splitIndex - 1);
                    String type = line.substring(splitIndex + 1);
                    if (type.equals("+")) {
                        examples.add(new Example(str, true));
                    } else if (type.equals("-")) {
                        examples.add(new Example(str, false));
                    } else {
                        throw new RuntimeException("example type incorrect");
                    }
                }
                line = br.readLine();
            }
            line = br.readLine();
            while (line.isEmpty() || line.startsWith("//")) {
                line = br.readLine();
            }
            while (line != null && !line.isEmpty()) {
                if (!line.startsWith("//")) {
                    gt = line;
                    break;
                }
                line = br.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new BenchmarkPair(Integer.valueOf(index), examples, gt);
    }

    public void run_misc(String readRegexPath, String readSpecPath, String writeRegexPath, String writeSpecPath) {
        StringBuilder sb_regex = new StringBuilder();
        StringBuilder sb_spec = new StringBuilder();
        try (BufferedReader br_regex = new BufferedReader(new FileReader(new File(readRegexPath)));
             BufferedReader br_spec = new BufferedReader(new FileReader(new File(readSpecPath)));){
            int i = 1;
            String spec = br_spec.readLine();
            String regex = br_regex.readLine();
            while (regex != null) {
                sb_regex.append(i + " " + regex + "\n");
                sb_spec.append(i + " " + spec + "\n");
                regex = br_regex.readLine();
                spec = br_spec.readLine();
                ++i;
                if (regex != null && spec != null && !regex.isEmpty() && !spec.isEmpty()) continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            PrintWriter out = new PrintWriter(writeRegexPath);
            out.println(sb_regex.toString());
            out.close();
            out = new PrintWriter(writeSpecPath);
            out.println(sb_spec.toString());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String run_example_single(String spec) {
        ExampleGenerator example_gen = new ExampleGenerator();
        SoDataGenerator so_gen = new SoDataGenerator();
        try {
            StringBuilder sb = new StringBuilder();
            SpecLang.Symbol fixedRegex = so_gen.generate(spec);
            Set<String> examples = example_gen.generate(fixedRegex.toRegex(), 0);
            sb.append("// example \n");
            for (String ex : examples) {
                sb.append(ex);
                sb.append("\n");
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "null";
        }
    }

    public void run_example(String inputRegexPath, String inputSpecPath, String outputExamplePath) {
        ExampleGenerator example_gen = new ExampleGenerator();
        SketchGenerator sketch_gen = new SketchGenerator();
        StringBuilder sb_unsuccess_spec = new StringBuilder();
        try (BufferedReader br_spec = new BufferedReader(new FileReader(new File(inputSpecPath)));){
            String spec = br_spec.readLine();
            while (spec != null) {
                BenchmarkPair specIns = this.process_line(spec);
                int i = specIns.index;
                spec = specIns.instance;
                if (spec.contains("null")) {
                    spec = br_spec.readLine();
                    if (spec != null && !spec.isEmpty()) continue;
                    break;
                }
                String curr_outputExamplePath = outputExamplePath + "/" + i;
                StringBuilder sb = new StringBuilder();
                SpecLang.Symbol fixedRegex = sketch_gen.generate(spec);
                System.out.println("-----------------");
                System.out.println("Process line " + i);
                System.out.println("Input: " + spec + "; Regex: " + fixedRegex.toRegex());
                Set<String> examples = example_gen.generate(fixedRegex.toRegex(), i);
                sb.append("// example \n");
                for (String ex : examples) {
                    sb.append(ex);
                    sb.append("\n");
                }
                sb.append("\n");
                sb.append("// ground truth \n");
                sb.append(spec);
                try {
                    PrintWriter out = new PrintWriter(curr_outputExamplePath);
                    out.println(sb.toString());
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (noexample_error.contains(i)) {
                    sb_unsuccess_spec.append(i + " " + spec + "\n");
                }
                if ((spec = br_spec.readLine()) != null && !spec.isEmpty()) continue;
                break;
            }
            br_spec.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            PrintWriter out = new PrintWriter(inputSpecPath);
            out.println(sb_unsuccess_spec.toString());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("no example empty: " + noexample_empty);
        System.out.println("no example empty #: " + noexample_empty.size());
        System.out.println("no example error:" + noexample_error);
        System.out.println("no example error #:" + noexample_error.size());
    }

    public void run_tokenizeSketch(String inputSketchPath, String outputSketchPath) {
        SketchGenerator gen = new SketchGenerator();
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(new File(inputSketchPath)));){
            int i = 1;
            String line = br.readLine();
            while (line != null) {
                line = line.replaceAll(" ", "");
                System.out.println("------------------");
                System.out.println("Process line " + i);
                System.out.println("Input: " + line);
                if (line.contains("null")) {
                    sb.append("null");
                } else {
                    SpecLang.Symbol spec = gen.generate(line);
                    StringBuilder skb = new StringBuilder();
                    spec.toSketch(skb, 0);
                    System.out.println("Output: " + skb);
                    sb.append((CharSequence)skb);
                }
                line = br.readLine();
                ++i;
                if (line.isEmpty()) {
                    break;
                }
                sb.append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            PrintWriter out = new PrintWriter(outputSketchPath);
            out.println(sb.toString());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run_sketch(String inputSketchPath, String outputSketchPath) {
        SketchGenerator gen = new SketchGenerator();
        try (BufferedReader br = new BufferedReader(new FileReader(new File(inputSketchPath)));){
            int i = 1;
            String line = br.readLine();
            while (line != null) {
                StringBuilder skb;
                line = line.replaceAll(" ", "");
                System.out.println("------------------");
                System.out.println("Process line " + i);
                System.out.println("Input: " + line);
                if (line.contains("null")) {
                    skb = new StringBuilder();
                    skb.append("null");
                } else {
                    SpecLang.Symbol spec = gen.generate(line);
                    skb = new StringBuilder();
                    spec.toSketch(skb, 0);
                    System.out.println("Output: " + skb);
                }
                try {
                    BufferedWriter out = new BufferedWriter(new FileWriter(outputSketchPath + i));
                    out.write("0 " + skb);
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                line = br.readLine();
                ++i;
                if (!line.isEmpty()) continue;
                break;
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run_data(DataGenerator gen, String inputDataPath, String outputDataPath) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(new File(inputDataPath)));){
            int i = 1;
            String line = br.readLine();
            while (line != null) {
                line = line.replaceAll(" ", "");
                System.out.println("--------------------------");
                System.out.println("Process line " + i++);
                System.out.println("Input: " + line);
                try {
                    SpecLang.Symbol spec = gen.generate(line);
                    System.out.println("Output: " + spec.toRegex());
                    if (transformTarg == 0) {
                        sb.append(spec.toString());
                    } else {
                        sb.append(spec.toRegex());
                    }
                }
                catch (Exception e) {
                    sb.append("null");
                }
                line = br.readLine();
                if (line.isEmpty()) break;
                sb.append("\n");
            }
            br.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            PrintWriter out = new PrintWriter(outputDataPath);
            out.println(sb.toString());
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run_popl(String inputDataPath, String inputNLPath, String outputDir) {
        int empty_regex_count = 0;
        EvaluateRegex er = new EvaluateRegex();
        PoplDataGenerator gen = new PoplDataGenerator();
        StringBuilder sb_targ = new StringBuilder();
        StringBuilder sb_src = new StringBuilder();
        StringBuilder sb_spec = new StringBuilder();
        try (BufferedReader br_targ = new BufferedReader(new FileReader(new File(inputDataPath)));
             BufferedReader br_src = new BufferedReader(new FileReader(new File(inputNLPath)));){
            String targ = br_targ.readLine();
            String src = br_src.readLine();
            while (true) {
                targ = targ.replaceAll(" ", "");
                try {
                    SpecLang.Symbol spec = gen.generate(targ);
                    String regex = spec.toRegex();
                    if (er.evaluateEmpty(regex)) {
                        ++empty_regex_count;
                        throw new RuntimeException();
                    }
                    sb_targ.append(regex);
                    sb_spec.append(spec.toString());
                    System.out.println("Output: " + regex);
                }
                catch (Exception e) {
                    targ = br_targ.readLine();
                    src = br_src.readLine();
                    if (targ != null && !targ.isEmpty() && src != null) {
                        if (!src.isEmpty()) continue;
                    }
                    break;
                }
                if (src.contains("<M0>")) {
                    src = src.replace("<M0>", "\"!\"");
                }
                if (src.contains("<M1>")) {
                    src = src.replace("<M1>", "\"@\"");
                }
                if (src.contains("<M2>")) {
                    src = src.replace("<M2>", "\"#\"");
                }
                if (src.contains("<M3>")) {
                    src = src.replace("<M3>", "\"$\"");
                }
                System.out.println("src: " + src);
                sb_src.append(src);
                targ = br_targ.readLine();
                src = br_src.readLine();
                if (targ == null || targ.isEmpty() || src == null) break;
                if (src.isEmpty()) {
                    break;
                }
                sb_src.append("\n");
                sb_targ.append("\n");
                sb_spec.append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            PrintWriter out_targ = new PrintWriter(outputDir + "targ-popl.txt");
            out_targ.println(sb_targ.toString());
            out_targ.close();
            PrintWriter out_src = new PrintWriter(outputDir + "src-popl.txt");
            out_src.println(sb_src.toString());
            out_src.close();
            PrintWriter out_spec = new PrintWriter(outputDir + "spec-popl.txt");
            out_spec.println(sb_spec.toString());
            out_spec.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("empty_regex: " + empty_regex_count);
    }

    public BenchmarkPair process_line(String line) {
        System.out.println(line);
        int split = line.indexOf(" ");
        int index = Integer.valueOf(line.substring(0, split));
        String instance = line.substring(split + 1);
        return new BenchmarkPair(index, instance);
    }

    static {
        tokenize = 0;
        transformTarg = 0;
        holeDepth = 0;
        exampleNum = 5;
        example_per_iter = 3;
        length_min = 1;
        length_max = 20;
        limit = 1;
        transitionVisitLimit = 2000;
        noexample_empty = new ArrayList<Integer>();
        noexample_error = new ArrayList<Integer>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("[<VOW>]", "<VOW>");
        map.put("[<LET>]", "<LET>");
        map.put("[<LOW>]", "<LOW>");
        map.put("[<CAP>]", "<CAP>");
        map.put("[<NUM>]", "<NUM>");
        map.put("[<ANY>]", "<ANY>");
        map.put("[<M0>]", "<M0>");
        map.put("[<M1>]", "<M1>");
        map.put("[<M2>]", "<M2>");
        map.put("[<M3>]", "<M3>");
        parseTerminals = Collections.unmodifiableMap(map);
    }
}

