/*
 * Decompiled with CFR 0.152.
 */
package datagen;

import datagen.DataGenerator;
import datagen.ExceptionErrorStrategy;
import datagen.MyErrorListener;
import datagen.ast.data_so.so_CFGLexer;
import datagen.ast.data_so.so_CFGParser;
import datagen.ast.data_so.so_CFGVisitor;
import datagen.spec.SpecLang;
import java.util.Arrays;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.AbstractParseTreeVisitor;
import org.antlr.v4.runtime.tree.ParseTree;

public class SoDataGenerator
extends AbstractParseTreeVisitor<Object>
implements so_CFGVisitor<Object>,
DataGenerator {
    @Override
    public SpecLang.Symbol generate(String regex) throws Exception {
        CodePointCharStream input = CharStreams.fromString((String)regex);
        so_CFGLexer lexer = new so_CFGLexer((CharStream)input);
        lexer.addErrorListener((ANTLRErrorListener)MyErrorListener.INSTANCE);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        so_CFGParser parser = new so_CFGParser((TokenStream)tokens);
        parser.setErrorHandler((ANTLRErrorStrategy)new ExceptionErrorStrategy());
        so_CFGParser.ProgramContext tree = parser.program();
        if (!tree.getText().equals(regex)) {
            throw new Exception();
        }
        SpecLang.Symbol ret = (SpecLang.Symbol)this.visit((ParseTree)tree);
        return ret;
    }

    @Override
    public Object visitCharClassProg(so_CFGParser.CharClassProgContext ctx) {
        SpecLang.Terminal ret = new SpecLang.Terminal(ctx.getText());
        return ret;
    }

    @Override
    public Object visitStartwithProg(so_CFGParser.StartwithProgContext ctx) {
        SpecLang.Symbol arg0 = (SpecLang.Symbol)this.visit((ParseTree)ctx.program());
        SpecLang.StartsWith ret = new SpecLang.StartsWith(arg0);
        return ret;
    }

    @Override
    public Object visitEndwithProg(so_CFGParser.EndwithProgContext ctx) {
        SpecLang.Symbol arg0 = (SpecLang.Symbol)this.visit((ParseTree)ctx.program());
        SpecLang.EndsWith ret = new SpecLang.EndsWith(arg0);
        return ret;
    }

    @Override
    public Object visitContainProg(so_CFGParser.ContainProgContext ctx) {
        SpecLang.Symbol arg0 = (SpecLang.Symbol)this.visit((ParseTree)ctx.program());
        SpecLang.Contains ret = new SpecLang.Contains(arg0);
        return ret;
    }

    @Override
    public Object visitOptionalProg(so_CFGParser.OptionalProgContext ctx) {
        SpecLang.Symbol arg0 = (SpecLang.Symbol)this.visit((ParseTree)ctx.program());
        SpecLang.Optional ret = new SpecLang.Optional(arg0);
        return ret;
    }

    @Override
    public Object visitStarProg(so_CFGParser.StarProgContext ctx) {
        SpecLang.Symbol arg0 = (SpecLang.Symbol)this.visit((ParseTree)ctx.program());
        SpecLang.RepeatAtLeast ret = new SpecLang.RepeatAtLeast(arg0, 0);
        return ret;
    }

    @Override
    public Object visitRepeatProg(so_CFGParser.RepeatProgContext ctx) {
        SpecLang.Symbol arg0 = (SpecLang.Symbol)this.visit((ParseTree)ctx.program());
        int arg1 = Integer.valueOf(ctx.INT().getText());
        SpecLang.Repeat ret = new SpecLang.Repeat(arg0, arg1);
        return ret;
    }

    @Override
    public Object visitRepeatAtLeastProg(so_CFGParser.RepeatAtLeastProgContext ctx) {
        SpecLang.Symbol arg0 = (SpecLang.Symbol)this.visit((ParseTree)ctx.program());
        int arg1 = Integer.valueOf(ctx.INT().getText());
        SpecLang.RepeatAtLeast ret = new SpecLang.RepeatAtLeast(arg0, arg1);
        return ret;
    }

    @Override
    public Object visitRepeatRangeProg(so_CFGParser.RepeatRangeProgContext ctx) {
        SpecLang.Symbol arg0 = (SpecLang.Symbol)this.visit((ParseTree)ctx.program());
        int arg1 = Integer.valueOf(ctx.INT(0).getText());
        int arg2 = Integer.valueOf(ctx.INT(1).getText());
        SpecLang.RepeatRange ret = new SpecLang.RepeatRange(arg0, arg1, arg2);
        return ret;
    }

    @Override
    public Object visitConcatProg(so_CFGParser.ConcatProgContext ctx) {
        SpecLang.Symbol arg0 = (SpecLang.Symbol)this.visit((ParseTree)ctx.program(0));
        SpecLang.Symbol arg1 = (SpecLang.Symbol)this.visit((ParseTree)ctx.program(1));
        SpecLang.Concat ret = new SpecLang.Concat(arg0, arg1);
        return ret;
    }

    @Override
    public Object visitNotProg(so_CFGParser.NotProgContext ctx) {
        SpecLang.Symbol arg0 = (SpecLang.Symbol)this.visit((ParseTree)ctx.program());
        SpecLang.Not ret = new SpecLang.Not(arg0);
        return ret;
    }

    @Override
    public Object visitNotCCProg(so_CFGParser.NotCCProgContext ctx) {
        SpecLang.Symbol arg0 = (SpecLang.Symbol)this.visit((ParseTree)ctx.program());
        SpecLang.NotCC ret = new SpecLang.NotCC(arg0);
        return ret;
    }

    @Override
    public Object visitConstProg(so_CFGParser.ConstProgContext ctx) {
        String str = ctx.CONST().getText();
        char[] charStr = str.toCharArray();
        charStr = Arrays.copyOfRange(charStr, 1, charStr.length - 1);
        assert (charStr.length >= 2);
        SpecLang.Terminal arg1 = new SpecLang.Terminal("<" + charStr[0] + ">");
        SpecLang.Symbol arg2 = new SpecLang.Terminal("<" + charStr[1] + ">");
        for (char i : Arrays.copyOfRange(charStr, 2, charStr.length)) {
            SpecLang.Terminal tmpArgs = new SpecLang.Terminal("<" + i + ">");
            arg2 = new SpecLang.Concat(arg2, tmpArgs);
        }
        SpecLang.Concat ret = new SpecLang.Concat(arg1, arg2);
        return ret;
    }

    @Override
    public Object visitAndProg(so_CFGParser.AndProgContext ctx) {
        SpecLang.Symbol arg0 = (SpecLang.Symbol)this.visit((ParseTree)ctx.program(0));
        SpecLang.Symbol arg1 = (SpecLang.Symbol)this.visit((ParseTree)ctx.program(1));
        SpecLang.And ret = new SpecLang.And(arg0, arg1);
        return ret;
    }

    @Override
    public Object visitOrProg(so_CFGParser.OrProgContext ctx) {
        SpecLang.Symbol arg0 = (SpecLang.Symbol)this.visit((ParseTree)ctx.program(0));
        SpecLang.Symbol arg1 = (SpecLang.Symbol)this.visit((ParseTree)ctx.program(1));
        SpecLang.Or ret = new SpecLang.Or(arg0, arg1);
        return ret;
    }

    @Override
    public Object visitSepProg(so_CFGParser.SepProgContext ctx) {
        throw new RuntimeException();
    }

    @Override
    public Object visitAllowProg(so_CFGParser.AllowProgContext ctx) {
        return null;
    }

    @Override
    public Object visitLengthRangeProg(so_CFGParser.LengthRangeProgContext ctx) {
        return null;
    }

    @Override
    public Object visitLengthAtLeastProg(so_CFGParser.LengthAtLeastProgContext ctx) {
        return null;
    }

    @Override
    public Object visitLengthProg(so_CFGParser.LengthProgContext ctx) {
        return null;
    }

    @Override
    public Object visitEmptyProg(so_CFGParser.EmptyProgContext ctx) {
        SpecLang.Empty ret = new SpecLang.Empty("null");
        return ret;
    }
}

