/*
 * Decompiled with CFR 0.152.
 */
package datagen.spec;

import datagen.Main;
import java.util.ArrayList;

public class SpecLang {

    public static class NotCC
    extends NonTerminal {
        public Symbol arg0;

        public NotCC(Symbol arg0) {
            this.arg0 = arg0;
        }

        public int hashCode() {
            return this.arg0.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof NotCC)) {
                return false;
            }
            NotCC other = (NotCC)o;
            return other.arg0.equals(this.arg0);
        }

        public String toString() {
            if (Main.tokenize == 1) {
                return "notcc ( " + this.arg0 + " )";
            }
            return "notcc(" + this.arg0 + ")";
        }

        @Override
        public ArrayList<Symbol> toSketch(StringBuilder sb, int depth) {
            ArrayList<Symbol> ret = new ArrayList<Symbol>();
            if (depth == Main.holeDepth) {
                if (Main.tokenize == 1) {
                    sb.append("? { ");
                } else {
                    sb.append("?{");
                }
                ArrayList<Symbol> components = this.arg0.toSketch(sb, -1);
                for (int i = 0; i < components.size(); ++i) {
                    sb.append(components.get(i));
                    if (i + 1 >= components.size()) continue;
                    if (Main.tokenize == 1) {
                        sb.append(" , ");
                        continue;
                    }
                    sb.append(",");
                }
                if (Main.tokenize == 1) {
                    sb.append(" }");
                } else {
                    sb.append("}");
                }
            } else if (depth == -1) {
                ret.add(this);
            } else {
                if (Main.tokenize == 1) {
                    sb.append("notcc ( ");
                } else {
                    sb.append("notcc(");
                }
                this.arg0.toSketch(sb, depth + 1);
                if (Main.tokenize == 1) {
                    sb.append(" )");
                } else {
                    sb.append(")");
                }
            }
            return ret;
        }

        @Override
        public String toRegex() {
            String ccn = this.arg0.toRegex();
            String cc = "";
            cc = Main.mode.contains("example") || Main.mode.contains("evaluate") || Main.mode.contains("preverify") ? (ccn.contains("let") ? "A-Za-z" : (ccn.contains("num") ? "0-9" : (ccn.contains("vow") ? "AEIOUaeiou" : (ccn.contains("cap") ? "A-Z" : (ccn.contains("low") ? "a-z" : (ccn.contains("alphanum") ? "0-9A-Za-z" : (ccn.contains("hex") ? "A-Fa-f0-9" : (ccn.contains("spec") ? "-,;._+:!@#$%&^*=" : (ccn.contains("any") ? "<any>" : (ccn.contains("m0") ? "!" : (ccn.contains("m1") ? "@" : (ccn.contains("m2") ? "#" : (ccn.contains("m3") ? "$" : ccn.substring(1, ccn.length() - 1)))))))))))))) : ccn.substring(1, ccn.length() - 1);
            return "([^" + cc + "])";
        }
    }

    public static class StartsWith
    extends NonTerminal {
        public Symbol arg0;

        public StartsWith(Symbol arg0) {
            this.arg0 = arg0;
        }

        public int hashCode() {
            return this.arg0.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof StartsWith)) {
                return false;
            }
            StartsWith other = (StartsWith)o;
            return other.arg0.equals(this.arg0);
        }

        public String toString() {
            if (Main.tokenize == 1) {
                return "startwith ( " + this.arg0 + " )";
            }
            return "startwith(" + this.arg0 + ")";
        }

        @Override
        public ArrayList<Symbol> toSketch(StringBuilder sb, int depth) {
            ArrayList<Symbol> ret = new ArrayList<Symbol>();
            if (depth == Main.holeDepth) {
                if (Main.tokenize == 1) {
                    sb.append("? { ");
                } else {
                    sb.append("?{");
                }
                ArrayList<Symbol> components = this.arg0.toSketch(sb, -1);
                for (int i = 0; i < components.size(); ++i) {
                    sb.append(components.get(i));
                    if (i + 1 >= components.size()) continue;
                    if (Main.tokenize == 1) {
                        sb.append(" , ");
                        continue;
                    }
                    sb.append(",");
                }
                if (Main.tokenize == 1) {
                    sb.append(" }");
                } else {
                    sb.append("}");
                }
            } else if (depth == -1) {
                ret.add(this);
            } else {
                if (Main.tokenize == 1) {
                    sb.append("startwith ( ");
                } else {
                    sb.append("startwith(");
                }
                this.arg0.toSketch(sb, depth + 1);
                if (Main.tokenize == 1) {
                    sb.append(" )");
                } else {
                    sb.append(")");
                }
            }
            return ret;
        }

        @Override
        public String toRegex() {
            return "(" + this.arg0.toRegex() + ").*";
        }
    }

    public static class Optional
    extends NonTerminal {
        public Symbol arg0;

        public Optional(Symbol arg0) {
            this.arg0 = arg0;
        }

        public int hashCode() {
            return this.arg0.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof Optional)) {
                return false;
            }
            Optional other = (Optional)o;
            return other.arg0.equals(this.arg0);
        }

        public String toString() {
            if (Main.tokenize == 1) {
                return "optional ( " + this.arg0 + " )";
            }
            return "optional(" + this.arg0 + ")";
        }

        @Override
        public ArrayList<Symbol> toSketch(StringBuilder sb, int depth) {
            ArrayList<Symbol> ret = new ArrayList<Symbol>();
            if (depth == Main.holeDepth) {
                if (Main.tokenize == 1) {
                    sb.append("? { ");
                } else {
                    sb.append("?{");
                }
                ArrayList<Symbol> components = this.arg0.toSketch(sb, -1);
                for (int i = 0; i < components.size(); ++i) {
                    sb.append(components.get(i));
                    if (i + 1 >= components.size()) continue;
                    if (Main.tokenize == 1) {
                        sb.append(" , ");
                        continue;
                    }
                    sb.append(",");
                }
                if (Main.tokenize == 1) {
                    sb.append(" }");
                } else {
                    sb.append("}");
                }
            } else if (depth == -1) {
                ret.add(this);
            } else {
                if (Main.tokenize == 1) {
                    sb.append("optional ( ");
                } else {
                    sb.append("optional(");
                }
                this.arg0.toSketch(sb, depth + 1);
                if (Main.tokenize == 1) {
                    sb.append(" )");
                } else {
                    sb.append(")");
                }
            }
            return ret;
        }

        @Override
        public String toRegex() {
            return "(" + this.arg0.toRegex() + ")?";
        }
    }

    public static class RepeatRange
    extends NonTerminal {
        public Symbol arg0;
        public int arg1;
        public int arg2;

        public RepeatRange(Symbol arg0, int arg1, int arg2) {
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        public int hashCode() {
            return this.arg0.hashCode() << 7 + this.arg1 + this.arg2;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof RepeatRange)) {
                return false;
            }
            RepeatRange other = (RepeatRange)o;
            return other.arg0.equals(this.arg0) && other.arg1 == this.arg1 && other.arg2 == this.arg2;
        }

        public String toString() {
            if (Main.tokenize == 1) {
                return "repeatrange ( " + this.arg0 + " , " + this.arg1 + " , " + this.arg2 + " )";
            }
            return "repeatrange(" + this.arg0 + "," + this.arg1 + "," + this.arg2 + ")";
        }

        @Override
        public ArrayList<Symbol> toSketch(StringBuilder sb, int depth) {
            ArrayList<Symbol> ret = new ArrayList<Symbol>();
            if (depth == Main.holeDepth) {
                if (Main.tokenize == 1) {
                    sb.append("? { ");
                } else {
                    sb.append("?{");
                }
                ArrayList<Symbol> components = this.arg0.toSketch(sb, -1);
                for (int i = 0; i < components.size(); ++i) {
                    sb.append(components.get(i));
                    if (i + 1 >= components.size()) continue;
                    if (Main.tokenize == 1) {
                        sb.append(" , ");
                        continue;
                    }
                    sb.append(",");
                }
                if (Main.tokenize == 1) {
                    sb.append(" }");
                } else {
                    sb.append("}");
                }
            } else if (depth == -1) {
                ret.add(this);
            } else {
                if (Main.tokenize == 1) {
                    sb.append("repeat ( ");
                } else {
                    sb.append("repeat(");
                }
                this.arg0.toSketch(sb, depth + 1);
                if (Main.tokenize == 1) {
                    sb.append(" , ");
                } else {
                    sb.append(",");
                }
                sb.append(this.arg1);
                if (Main.tokenize == 1) {
                    sb.append(" , ");
                } else {
                    sb.append(",");
                }
                sb.append(this.arg2);
                if (Main.tokenize == 1) {
                    sb.append(" )");
                } else {
                    sb.append(")");
                }
            }
            return ret;
        }

        @Override
        public String toRegex() {
            return "(" + this.arg0.toRegex() + "){" + this.arg1 + "," + this.arg2 + "}";
        }
    }

    public static class Repeat
    extends NonTerminal {
        public Symbol arg0;
        public int arg1;

        public Repeat(Symbol arg0, int arg1) {
            this.arg0 = arg0;
            this.arg1 = arg1;
        }

        public int hashCode() {
            return this.arg0.hashCode() << 7 + this.arg1;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof RepeatAtLeast)) {
                return false;
            }
            RepeatAtLeast other = (RepeatAtLeast)o;
            return other.arg0.equals(this.arg0) && other.arg1 == this.arg1;
        }

        public String toString() {
            if (Main.tokenize == 1) {
                return "repeat ( " + this.arg0 + " , " + this.arg1 + " )";
            }
            return "repeat(" + this.arg0 + "," + this.arg1 + ")";
        }

        @Override
        public ArrayList<Symbol> toSketch(StringBuilder sb, int depth) {
            ArrayList<Symbol> ret = new ArrayList<Symbol>();
            if (depth == Main.holeDepth) {
                if (Main.tokenize == 1) {
                    sb.append("? { ");
                } else {
                    sb.append("?{");
                }
                ArrayList<Symbol> components = this.arg0.toSketch(sb, -1);
                for (int i = 0; i < components.size(); ++i) {
                    sb.append(components.get(i));
                    if (i + 1 >= components.size()) continue;
                    if (Main.tokenize == 1) {
                        sb.append(" , ");
                        continue;
                    }
                    sb.append(",");
                }
                if (Main.tokenize == 1) {
                    sb.append(" }");
                } else {
                    sb.append("}");
                }
            } else if (depth == -1) {
                ret.add(this);
            } else {
                if (Main.tokenize == 1) {
                    sb.append("repeat ( ");
                } else {
                    sb.append("repeat(");
                }
                this.arg0.toSketch(sb, depth + 1);
                if (Main.tokenize == 1) {
                    sb.append(" , ");
                } else {
                    sb.append(",");
                }
                sb.append(this.arg1);
                if (Main.tokenize == 1) {
                    sb.append(" )");
                } else {
                    sb.append(")");
                }
            }
            return ret;
        }

        @Override
        public String toRegex() {
            return "(" + this.arg0.toRegex() + "){" + this.arg1 + "}";
        }
    }

    public static class RepeatAtLeast
    extends NonTerminal {
        public Symbol arg0;
        public int arg1;

        public RepeatAtLeast(Symbol arg0, int arg1) {
            this.arg0 = arg0;
            this.arg1 = arg1;
        }

        public int hashCode() {
            return this.arg0.hashCode() << 7 + this.arg1;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof RepeatAtLeast)) {
                return false;
            }
            RepeatAtLeast other = (RepeatAtLeast)o;
            return other.arg0.equals(this.arg0) && other.arg1 == this.arg1;
        }

        public String toString() {
            if (this.arg1 == 0) {
                if (Main.tokenize == 1) {
                    return "star ( " + this.arg0 + " )";
                }
                return "star(" + this.arg0 + ")";
            }
            if (Main.tokenize == 1) {
                return "repeatatleast ( " + this.arg0 + " , " + this.arg1 + " )";
            }
            return "repeatatleast(" + this.arg0 + "," + this.arg1 + ")";
        }

        @Override
        public ArrayList<Symbol> toSketch(StringBuilder sb, int depth) {
            ArrayList<Symbol> ret = new ArrayList<Symbol>();
            if (depth == Main.holeDepth) {
                if (Main.tokenize == 1) {
                    sb.append("? { ");
                } else {
                    sb.append("?{");
                }
                ArrayList<Symbol> components = this.arg0.toSketch(sb, -1);
                for (int i = 0; i < components.size(); ++i) {
                    sb.append(components.get(i));
                    if (i + 1 >= components.size()) continue;
                    if (Main.tokenize == 1) {
                        sb.append(" , ");
                        continue;
                    }
                    sb.append(",");
                }
                if (Main.tokenize == 1) {
                    sb.append(" }");
                } else {
                    sb.append("}");
                }
            } else if (depth == -1) {
                ret.add(this);
            } else if (this.arg1 == 0) {
                if (Main.tokenize == 1) {
                    sb.append("star ( ");
                } else {
                    sb.append("star(");
                }
                this.arg0.toSketch(sb, depth + 1);
                if (Main.tokenize == 1) {
                    sb.append(" )");
                } else {
                    sb.append(")");
                }
            } else {
                if (Main.tokenize == 1) {
                    sb.append("repeatatleast ( ");
                } else {
                    sb.append("repeatatleast(");
                }
                this.arg0.toSketch(sb, depth + 1);
                if (Main.tokenize == 1) {
                    sb.append(" , ");
                } else {
                    sb.append(",");
                }
                sb.append(this.arg1);
                if (Main.tokenize == 1) {
                    sb.append(" )");
                } else {
                    sb.append(")");
                }
            }
            return ret;
        }

        @Override
        public String toRegex() {
            return "(" + this.arg0.toRegex() + "){" + this.arg1 + ",}";
        }
    }

    public static class Concat
    extends NonTerminal {
        public Symbol arg0;
        public Symbol arg1;

        public Concat(Symbol arg0, Symbol arg1) {
            this.arg0 = arg0;
            this.arg1 = arg1;
        }

        public int hashCode() {
            return this.arg0.hashCode() << 4 + this.arg1.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof Concat)) {
                return false;
            }
            Concat other = (Concat)o;
            return other.arg0.equals(this.arg0) && other.arg1.equals(this.arg1);
        }

        public String toString() {
            if (Main.tokenize == 1) {
                return "concat ( " + this.arg0 + " , " + this.arg1 + " )";
            }
            return "concat(" + this.arg0 + "," + this.arg1 + ")";
        }

        @Override
        public ArrayList<Symbol> toSketch(StringBuilder sb, int depth) {
            ArrayList<Symbol> ret = new ArrayList<Symbol>();
            if (depth == Main.holeDepth) {
                if (Main.tokenize == 1) {
                    sb.append("? { ");
                } else {
                    sb.append("?{");
                }
                ArrayList<Symbol> components = this.arg0.toSketch(sb, -1);
                components.addAll(this.arg1.toSketch(sb, -1));
                for (int i = 0; i < components.size(); ++i) {
                    sb.append(components.get(i));
                    if (i + 1 >= components.size()) continue;
                    if (Main.tokenize == 1) {
                        sb.append(" , ");
                        continue;
                    }
                    sb.append(",");
                }
                if (Main.tokenize == 1) {
                    sb.append(" }");
                } else {
                    sb.append("}");
                }
            } else if (depth == -1) {
                ret.add(this);
            } else {
                if (Main.tokenize == 1) {
                    sb.append("concat ( ");
                } else {
                    sb.append("concat(");
                }
                this.arg0.toSketch(sb, depth + 1);
                if (Main.tokenize == 1) {
                    sb.append(" , ");
                } else {
                    sb.append(",");
                }
                this.arg1.toSketch(sb, depth + 1);
                if (Main.tokenize == 1) {
                    sb.append(" )");
                } else {
                    sb.append(")");
                }
            }
            return ret;
        }

        @Override
        public String toRegex() {
            return "(" + this.arg0.toRegex() + ")(" + this.arg1.toRegex() + ")";
        }
    }

    public static class EndsWith
    extends NonTerminal {
        public Symbol arg0;

        public EndsWith(Symbol arg0) {
            this.arg0 = arg0;
        }

        public int hashCode() {
            return this.arg0.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof EndsWith)) {
                return false;
            }
            EndsWith other = (EndsWith)o;
            return other.arg0.equals(this.arg0);
        }

        public String toString() {
            if (Main.tokenize == 1) {
                return "endwith ( " + this.arg0 + " )";
            }
            return "endwith(" + this.arg0 + ")";
        }

        @Override
        public ArrayList<Symbol> toSketch(StringBuilder sb, int depth) {
            ArrayList<Symbol> ret = new ArrayList<Symbol>();
            if (depth == Main.holeDepth) {
                if (Main.tokenize == 1) {
                    sb.append("? { ");
                } else {
                    sb.append("?{");
                }
                ArrayList<Symbol> components = this.arg0.toSketch(sb, -1);
                for (int i = 0; i < components.size(); ++i) {
                    sb.append(components.get(i));
                    if (i + 1 >= components.size()) continue;
                    if (Main.tokenize == 1) {
                        sb.append(" , ");
                        continue;
                    }
                    sb.append(",");
                }
                if (Main.tokenize == 1) {
                    sb.append(" }");
                } else {
                    sb.append("}");
                }
            } else if (depth == -1) {
                ret.add(this);
            } else {
                if (Main.tokenize == 1) {
                    sb.append("endwith ( ");
                } else {
                    sb.append("endwith(");
                }
                this.arg0.toSketch(sb, depth + 1);
                if (Main.tokenize == 1) {
                    sb.append(" )");
                } else {
                    sb.append(")");
                }
            }
            return ret;
        }

        @Override
        public String toRegex() {
            return ".*(" + this.arg0.toRegex() + ")";
        }
    }

    public static class And
    extends NonTerminal {
        public Symbol arg0;
        public Symbol arg1;

        public And(Symbol arg0, Symbol arg1) {
            this.arg0 = arg0;
            this.arg1 = arg1;
        }

        public int hashCode() {
            return this.arg0.hashCode() << 3 + this.arg1.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof And)) {
                return false;
            }
            And other = (And)o;
            return other.arg0.equals(this.arg0) && other.arg1.equals(this.arg1);
        }

        public String toString() {
            if (Main.tokenize == 1) {
                return "and ( " + this.arg0 + " , " + this.arg1 + " )";
            }
            return "and(" + this.arg0 + "," + this.arg1 + ")";
        }

        @Override
        public ArrayList<Symbol> toSketch(StringBuilder sb, int depth) {
            ArrayList<Symbol> ret = new ArrayList<Symbol>();
            if (depth == Main.holeDepth) {
                if (Main.tokenize == 1) {
                    sb.append("? { ");
                } else {
                    sb.append("?{");
                }
                ArrayList<Symbol> components = this.arg0.toSketch(sb, -1);
                components.addAll(this.arg1.toSketch(sb, -1));
                for (int i = 0; i < components.size(); ++i) {
                    sb.append(components.get(i));
                    if (i + 1 >= components.size()) continue;
                    if (Main.tokenize == 1) {
                        sb.append(" , ");
                        continue;
                    }
                    sb.append(",");
                }
                if (Main.tokenize == 1) {
                    sb.append(" }");
                } else {
                    sb.append("}");
                }
            } else if (depth == -1) {
                ret.add(this);
            } else {
                if (Main.tokenize == 1) {
                    sb.append("and ( ");
                } else {
                    sb.append("and(");
                }
                this.arg0.toSketch(sb, depth + 1);
                if (Main.tokenize == 1) {
                    sb.append(" , ");
                } else {
                    sb.append(",");
                }
                this.arg1.toSketch(sb, depth + 1);
                if (Main.tokenize == 1) {
                    sb.append(" )");
                } else {
                    sb.append(")");
                }
            }
            return ret;
        }

        @Override
        public String toRegex() {
            return "((" + this.arg0.toRegex() + ")&(" + this.arg1.toRegex() + "))";
        }
    }

    public static class Or
    extends NonTerminal {
        public Symbol arg0;
        public Symbol arg1;

        public Or(Symbol arg0, Symbol arg1) {
            this.arg0 = arg0;
            this.arg1 = arg1;
        }

        public int hashCode() {
            return this.arg0.hashCode() << 2 + this.arg1.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof Or)) {
                return false;
            }
            Or other = (Or)o;
            return other.arg0.equals(this.arg0) && other.arg1.equals(this.arg1);
        }

        public String toString() {
            if (Main.tokenize == 1) {
                return "or ( " + this.arg0 + " , " + this.arg1 + " )";
            }
            return "or(" + this.arg0 + "," + this.arg1 + ")";
        }

        @Override
        public ArrayList<Symbol> toSketch(StringBuilder sb, int depth) {
            ArrayList<Symbol> ret = new ArrayList<Symbol>();
            if (depth == Main.holeDepth) {
                if (Main.tokenize == 1) {
                    sb.append("? { ");
                } else {
                    sb.append("?{");
                }
                ArrayList<Symbol> components = this.arg0.toSketch(sb, -1);
                components.addAll(this.arg1.toSketch(sb, -1));
                for (int i = 0; i < components.size(); ++i) {
                    sb.append(components.get(i));
                    if (i + 1 >= components.size()) continue;
                    if (Main.tokenize == 1) {
                        sb.append(" , ");
                        continue;
                    }
                    sb.append(",");
                }
                if (Main.tokenize == 1) {
                    sb.append(" }");
                } else {
                    sb.append("}");
                }
            } else if (depth == -1) {
                ret.add(this);
            } else {
                if (Main.tokenize == 1) {
                    sb.append("or ( ");
                } else {
                    sb.append("or(");
                }
                this.arg0.toSketch(sb, depth + 1);
                if (Main.tokenize == 1) {
                    sb.append(" , ");
                } else {
                    sb.append(",");
                }
                this.arg1.toSketch(sb, depth + 1);
                if (Main.tokenize == 1) {
                    sb.append(" )");
                } else {
                    sb.append(")");
                }
            }
            return ret;
        }

        @Override
        public String toRegex() {
            return "((" + this.arg0.toRegex() + ")|(" + this.arg1.toRegex() + "))";
        }
    }

    public static class Not
    extends NonTerminal {
        public Symbol arg0;

        public Not(Symbol arg0) {
            this.arg0 = arg0;
        }

        public int hashCode() {
            return this.arg0.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof Not)) {
                return false;
            }
            Not other = (Not)o;
            return other.arg0.equals(this.arg0);
        }

        public String toString() {
            if (Main.tokenize == 1) {
                return "not ( " + this.arg0 + " )";
            }
            return "not(" + this.arg0 + ")";
        }

        @Override
        public ArrayList<Symbol> toSketch(StringBuilder sb, int depth) {
            ArrayList<Symbol> ret = new ArrayList<Symbol>();
            if (depth == Main.holeDepth) {
                if (Main.tokenize == 1) {
                    sb.append("? { ");
                } else {
                    sb.append("?{");
                }
                ArrayList<Symbol> components = this.arg0.toSketch(sb, -1);
                for (int i = 0; i < components.size(); ++i) {
                    sb.append(components.get(i));
                    if (i + 1 >= components.size()) continue;
                    if (Main.tokenize == 1) {
                        sb.append(" , ");
                        continue;
                    }
                    sb.append(",");
                }
                if (Main.tokenize == 1) {
                    sb.append(" }");
                } else {
                    sb.append("}");
                }
            } else if (depth == -1) {
                ret.add(this);
            } else {
                if (Main.tokenize == 1) {
                    sb.append("not ( ");
                } else {
                    sb.append("not(");
                }
                this.arg0.toSketch(sb, depth + 1);
                if (Main.tokenize == 1) {
                    sb.append(" )");
                } else {
                    sb.append(")");
                }
            }
            return ret;
        }

        @Override
        public String toRegex() {
            return "~(" + this.arg0.toRegex() + ")";
        }
    }

    public static class Contains
    extends NonTerminal {
        public Symbol arg0;

        public Contains(Symbol arg0) {
            this.arg0 = arg0;
        }

        public int hashCode() {
            return this.arg0.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof Contains)) {
                return false;
            }
            Contains other = (Contains)o;
            return other.arg0.equals(this.arg0);
        }

        public String toString() {
            if (Main.tokenize == 1) {
                return "contain ( " + this.arg0 + " )";
            }
            return "contain(" + this.arg0 + ")";
        }

        @Override
        public ArrayList<Symbol> toSketch(StringBuilder sb, int depth) {
            ArrayList<Symbol> ret = new ArrayList<Symbol>();
            if (depth == Main.holeDepth) {
                if (Main.tokenize == 1) {
                    sb.append("? { ");
                } else {
                    sb.append("?{");
                }
                ArrayList<Symbol> components = this.arg0.toSketch(sb, -1);
                for (int i = 0; i < components.size(); ++i) {
                    sb.append(components.get(i));
                    if (i + 1 >= components.size()) continue;
                    if (Main.tokenize == 1) {
                        sb.append(" , ");
                        continue;
                    }
                    sb.append(",");
                }
                if (Main.tokenize == 1) {
                    sb.append(" }");
                } else {
                    sb.append("}");
                }
            } else if (depth == -1) {
                ret.add(this);
            } else {
                if (Main.tokenize == 1) {
                    sb.append("contain ( ");
                } else {
                    sb.append("contain(");
                }
                this.arg0.toSketch(sb, depth + 1);
                if (Main.tokenize == 1) {
                    sb.append(" )");
                } else {
                    sb.append(")");
                }
            }
            return ret;
        }

        @Override
        public String toRegex() {
            return ".*(" + this.arg0.toRegex() + ").*";
        }
    }

    public static abstract class NonTerminal
    extends Symbol {
    }

    public static class Empty
    extends Terminal {
        String name;

        public Empty(String name) {
            super(name);
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public String toRegex() {
            return "(#)";
        }
    }

    public static class Terminal
    extends Symbol {
        public final String name;

        public Terminal(String name) {
            this.name = name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o.equals(this)) {
                return true;
            }
            if (!(o instanceof Terminal)) {
                return false;
            }
            Terminal other = (Terminal)o;
            return other.name.equals(this.name);
        }

        public String toString() {
            if (Main.tokenize == 1) {
                return "<" + this.name.substring(1, this.name.length() - 1) + ">";
            }
            return this.name;
        }

        @Override
        public ArrayList<Symbol> toSketch(StringBuilder sb, int depth) {
            ArrayList<Symbol> ret = new ArrayList<Symbol>();
            if (depth == -1) {
                ret.add(this);
            } else if (Main.tokenize == 1) {
                sb.append("? { ");
                sb.append(this.toString());
                sb.append(" }");
            } else {
                sb.append("?{");
                sb.append(this.toString());
                sb.append("}");
            }
            return ret;
        }

        @Override
        public String toRegex() {
            String ccn = this.name;
            String cc = "";
            if (Main.mode.contains("example") || Main.mode.contains("evaluate") || Main.mode.contains("equiv") || Main.mode.contains("preverify")) {
                if (ccn.contains("any")) {
                    return ".";
                }
                cc = ccn.contains("let") ? "A-Za-z" : (ccn.contains("num") ? "0-9" : (ccn.contains("vow") ? "AEIOUaeiou" : (ccn.contains("cap") ? "A-Z" : (ccn.contains("low") ? "a-z" : (ccn.contains("alphanum") ? "0-9A-Za-z" : (ccn.contains("hex") ? "A-Fa-f0-9" : (ccn.contains("spec") ? "-,;._+:!@#$%&^*=" : (ccn.contains("any") ? "<any>" : (ccn.equals("<^>") ? "\\\\^" : (ccn.contains("m0") ? "!" : (ccn.contains("m1") ? "@" : (ccn.contains("m2") ? "#" : (ccn.contains("m3") ? "$" : ccn.substring(1, ccn.length() - 1))))))))))))));
                return "[" + cc + "]";
            }
            return this.name;
        }
    }

    public static abstract class Symbol {
        public abstract ArrayList<Symbol> toSketch(StringBuilder var1, int var2);

        public abstract String toRegex();
    }
}

