/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import edu.stanford.nlp.sempre.ChartParserState;
import edu.stanford.nlp.sempre.CoarseParser;
import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.DerivationStream;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.Params;
import edu.stanford.nlp.sempre.Parser;
import edu.stanford.nlp.sempre.ReinforcementParser;
import edu.stanford.nlp.sempre.Rule;
import edu.stanford.nlp.sempre.SemanticFn;
import fig.basic.LogInfo;
import fig.basic.MapUtils;
import fig.basic.StopWatchSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

abstract class AbstractReinforcementParserState
extends ChartParserState {
    protected final ReinforcementParser parser;
    protected final CoarseParser coarseParser;
    protected CoarseParser.CoarseParserState coarseParserState;
    protected static final double EPSILON = 1.0E-19;

    public AbstractReinforcementParserState(ReinforcementParser parser, Params params, Example ex, boolean computeExpectedCounts) {
        super(parser, params, ex, computeExpectedCounts);
        this.parser = parser;
        this.coarseParser = parser.coarseParser;
    }

    protected abstract void addToAgenda(DerivationStream var1);

    protected boolean coarseAllows(String cat, int start, int end) {
        return this.coarseParserState == null || this.coarseParserState.coarseAllows(cat, start, end);
    }

    protected boolean addToBoundedChart(Derivation deriv) {
        ArrayList<Derivation> derivations = (ArrayList<Derivation>)this.chart[deriv.start][deriv.end].get(deriv.cat);
        ++this.totalGeneratedDerivs;
        if (Parser.opts.visualizeChartFilling) {
            this.chartFillingList.add(new ChartParserState.CatSpan(deriv.start, deriv.end, deriv.cat));
        }
        if (derivations == null) {
            derivations = new ArrayList<Derivation>();
            this.chart[deriv.start][deriv.end].put(deriv.cat, derivations);
        }
        if (derivations.size() < this.getBeamSize()) {
            derivations.add(deriv);
            Collections.sort(derivations, Derivation.derivScoreComparator);
            return true;
        }
        return false;
    }

    protected void combineWithChartDerivations(Derivation deriv) {
        this.expandDerivRightwards(deriv);
        this.expandDerivLeftwards(deriv);
        this.applyCatUnaryRules(deriv);
    }

    private void expandDerivRightwards(Derivation leftChild) {
        Map<String, List<Rule>> rhsCategoriesToRules;
        if (this.parser.verbose(6)) {
            LogInfo.begin_track((String)"Expanding rightward", (Object[])new Object[0]);
        }
        if ((rhsCategoriesToRules = this.parser.leftToRightSiblingMap.get(leftChild.cat)) != null) {
            int i = 1;
            while (leftChild.end + i <= this.numTokens) {
                Sets.SetView intersection = Sets.intersection(rhsCategoriesToRules.keySet(), this.chart[leftChild.end][leftChild.end + i].keySet());
                for (String rhsCategory : intersection) {
                    List<Rule> compatibleRules = rhsCategoriesToRules.get(rhsCategory);
                    List rightChildren = (List)this.chart[leftChild.end][leftChild.end + i].get(rhsCategory);
                    this.generateParentDerivations(leftChild, rightChildren, true, compatibleRules);
                }
                ++i;
            }
            if (leftChild.end < this.numTokens) {
                this.handleTerminalExpansion(leftChild, false, rhsCategoriesToRules);
            }
        }
        if (this.parser.verbose(6)) {
            LogInfo.end_track();
        }
    }

    private void expandDerivLeftwards(Derivation rightChild) {
        Map<String, List<Rule>> lhsCategorisToRules;
        if (this.parser.verbose(5)) {
            LogInfo.begin_track((String)"Expanding leftward", (Object[])new Object[0]);
        }
        if ((lhsCategorisToRules = this.parser.rightToLeftSiblingMap.get(rightChild.cat)) != null) {
            int i = 1;
            while (rightChild.start - i >= 0) {
                Sets.SetView intersection = Sets.intersection(lhsCategorisToRules.keySet(), this.chart[rightChild.start - i][rightChild.start].keySet());
                for (String lhsCategory : intersection) {
                    List<Rule> compatibleRules = lhsCategorisToRules.get(lhsCategory);
                    List leftChildren = (List)this.chart[rightChild.start - i][rightChild.start].get(lhsCategory);
                    this.generateParentDerivations(rightChild, leftChildren, false, compatibleRules);
                }
                ++i;
            }
            if (rightChild.start > 0) {
                this.handleTerminalExpansion(rightChild, true, lhsCategorisToRules);
            }
        }
        if (this.parser.verbose(5)) {
            LogInfo.end_track();
        }
    }

    private void generateParentDerivations(Derivation expandedDeriv, List<Derivation> otherDerivs, boolean expandedLeftChild, List<Rule> compatibleRules) {
        for (Derivation otherDeriv : otherDerivs) {
            Derivation rightChild;
            Derivation leftChild;
            if (expandedLeftChild) {
                leftChild = expandedDeriv;
                rightChild = otherDeriv;
            } else {
                leftChild = otherDeriv;
                rightChild = expandedDeriv;
            }
            ArrayList<Derivation> children = new ArrayList<Derivation>();
            children.add(leftChild);
            children.add(rightChild);
            for (Rule rule : compatibleRules) {
                DerivationStream resDerivations;
                if (!this.coarseAllows(rule.lhs, leftChild.start, rightChild.end) || !(resDerivations = this.applyRule(leftChild.start, rightChild.end, rule, children)).hasNext()) continue;
                this.addToAgenda(resDerivations);
            }
        }
    }

    private DerivationStream applyRule(int start, int end, Rule rule, List<Derivation> children) {
        try {
            if (Parser.opts.verbose >= 5) {
                LogInfo.logs((String)"applyRule %s %s %s %s", (Object[])new Object[]{start, end, rule, children});
            }
            StopWatchSet.begin((String)rule.getSemRepn());
            StopWatchSet.begin((String)rule.toString());
            DerivationStream results = rule.sem.call(this.ex, new SemanticFn.CallInfo(rule.lhs, start, end, rule, (List<Derivation>)ImmutableList.copyOf(children)));
            StopWatchSet.end();
            StopWatchSet.end();
            return results;
        }
        catch (Exception e) {
            LogInfo.errors((String)"Composition failed: rule = %s, children = %s", (Object[])new Object[]{rule, children});
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void applyCatUnaryRules(Derivation deriv) {
        if (this.parser.verbose(4)) {
            LogInfo.begin_track((String)"Category unary rules", (Object[])new Object[0]);
        }
        for (Rule rule : this.parser.catUnaryRules) {
            if (!this.coarseAllows(rule.lhs, deriv.start, deriv.end) || !deriv.cat.equals(rule.rhs.get(0))) continue;
            DerivationStream resDerivations = this.applyRule(deriv.start, deriv.end, rule, Collections.singletonList(deriv));
            this.addToAgenda(resDerivations);
        }
        if (this.parser.verbose(4)) {
            LogInfo.end_track();
        }
    }

    public List<DerivationStream> gatherRhsTerminalsDerivations() {
        ArrayList<DerivationStream> derivs = new ArrayList<DerivationStream>();
        List<Derivation> empty = Collections.emptyList();
        for (int i = 0; i < this.numTokens; ++i) {
            for (int j = i + 1; j <= this.numTokens; ++j) {
                for (Rule rule : (List)MapUtils.get(this.parser.terminalsToRulesList, (Object)this.phrases[i][j], Collections.emptyList())) {
                    if (!this.coarseAllows(rule.lhs, i, j)) continue;
                    derivs.add(this.applyRule(i, j, rule, empty));
                }
            }
        }
        return derivs;
    }

    private void handleTerminalExpansion(Derivation child, boolean before, Map<String, List<Rule>> categoriesToRules) {
        int end;
        String phrase = before ? this.phrases[child.start - 1][child.start] : this.phrases[child.end][child.end + 1];
        int start = before ? child.start - 1 : child.start;
        int n = end = before ? child.end : child.end + 1;
        if (categoriesToRules.containsKey(phrase)) {
            ArrayList<Derivation> children = new ArrayList<Derivation>();
            children.add(child);
            for (Rule rule : categoriesToRules.get(phrase)) {
                DerivationStream resDerivations;
                if (!this.coarseAllows(rule.lhs, start, end) || !(resDerivations = this.applyRule(start, end, rule, children)).hasNext()) continue;
                this.addToAgenda(resDerivations);
            }
        }
    }
}

