/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import edu.stanford.nlp.sempre.Formula;
import fig.basic.AbstractLispTree;
import fig.basic.LispTree;
import java.util.ArrayList;
import java.util.List;

public class ActionFormula
extends Formula {
    public final Mode mode;
    public final List<Formula> args;

    public ActionFormula(Mode mode, List<Formula> args) {
        this.mode = mode;
        this.args = args;
    }

    public static Mode parseMode(String mode) {
        if (mode == null) {
            return null;
        }
        for (Mode m : Mode.values()) {
            if (!m.toString().equals(mode)) continue;
            return m;
        }
        if (mode.startsWith(":")) {
            throw new RuntimeException("Unsupported ActionFormula mode");
        }
        return null;
    }

    @Override
    public LispTree toLispTree() {
        LispTree tree = (LispTree)LispTree.proto.newList();
        tree.addChild(this.mode.toString());
        for (Formula arg : this.args) {
            tree.addChild((AbstractLispTree)arg.toLispTree());
        }
        return tree;
    }

    @Override
    public void forEach(Function<Formula, Boolean> func) {
        if (!((Boolean)func.apply((Object)this)).booleanValue()) {
            for (Formula arg : this.args) {
                arg.forEach(func);
            }
        }
    }

    @Override
    public Formula map(Function<Formula, Formula> transform) {
        Formula result = (Formula)transform.apply((Object)this);
        if (result != null) {
            return result;
        }
        ArrayList newArgs = Lists.newArrayList();
        for (Formula arg : this.args) {
            newArgs.add(arg.map(transform));
        }
        return new ActionFormula(this.mode, newArgs);
    }

    @Override
    public List<Formula> mapToList(Function<Formula, List<Formula>> transform, boolean alwaysRecurse) {
        List res = (List)transform.apply((Object)this);
        if (res.isEmpty() || alwaysRecurse) {
            for (Formula arg : this.args) {
                res.addAll(arg.mapToList(transform, alwaysRecurse));
            }
        }
        return res;
    }

    @Override
    public boolean equals(Object thatObj) {
        if (!(thatObj instanceof ActionFormula)) {
            return false;
        }
        ActionFormula that = (ActionFormula)thatObj;
        if (!this.mode.equals((Object)that.mode)) {
            return false;
        }
        return this.args.equals(that.args);
    }

    @Override
    public int computeHashCode() {
        int hash = 2127912214;
        hash = hash * -744332180 + this.mode.hashCode();
        hash = hash * -744332180 + this.args.hashCode();
        return hash;
    }

    public static enum Mode {
        primitive(":"),
        sequential(":s"),
        repeat(":loop"),
        conditional(":if"),
        whileloop(":while"),
        forset(":for"),
        foreach(":foreach"),
        block(":blk"),
        blockr(":blkr"),
        isolate(":isolate"),
        other(":?");

        private final String value;

        private Mode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

