/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.google.common.base.Function;
import edu.stanford.nlp.sempre.Formula;
import fig.basic.AbstractLispTree;
import fig.basic.LispTree;
import java.util.List;

public class AggregateFormula
extends Formula {
    public final Mode mode;
    public final Formula child;

    public AggregateFormula(Mode mode, Formula child) {
        this.mode = mode;
        this.child = child;
    }

    @Override
    public LispTree toLispTree() {
        LispTree tree = (LispTree)LispTree.proto.newList();
        tree.addChild(this.mode.toString());
        tree.addChild((AbstractLispTree)this.child.toLispTree());
        return tree;
    }

    public static Mode parseMode(String mode) {
        if ("count".equals(mode)) {
            return Mode.count;
        }
        if ("sum".equals(mode)) {
            return Mode.sum;
        }
        if ("avg".equals(mode)) {
            return Mode.avg;
        }
        if ("min".equals(mode)) {
            return Mode.min;
        }
        if ("max".equals(mode)) {
            return Mode.max;
        }
        return null;
    }

    @Override
    public void forEach(Function<Formula, Boolean> func) {
        if (!((Boolean)func.apply((Object)this)).booleanValue()) {
            this.child.forEach(func);
        }
    }

    @Override
    public Formula map(Function<Formula, Formula> func) {
        Formula result = (Formula)func.apply((Object)this);
        return result == null ? new AggregateFormula(this.mode, this.child.map(func)) : result;
    }

    @Override
    public List<Formula> mapToList(Function<Formula, List<Formula>> func, boolean alwaysRecurse) {
        List res = (List)func.apply((Object)this);
        if (res.isEmpty() || alwaysRecurse) {
            res.addAll(this.child.mapToList(func, alwaysRecurse));
        }
        return res;
    }

    @Override
    public boolean equals(Object thatObj) {
        if (!(thatObj instanceof AggregateFormula)) {
            return false;
        }
        AggregateFormula that = (AggregateFormula)thatObj;
        if (!this.mode.equals((Object)that.mode)) {
            return false;
        }
        return this.child.equals(that.child);
    }

    @Override
    public int computeHashCode() {
        int hash = 2127912214;
        hash = hash * -744332180 + this.mode.toString().hashCode();
        hash = hash * -744332180 + this.child.hashCode();
        return hash;
    }

    public static enum Mode {
        count,
        sum,
        avg,
        min,
        max;

    }
}

