/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.SemType;
import edu.stanford.nlp.sempre.SemTypeHierarchy;
import edu.stanford.nlp.sempre.TopSemType;
import edu.stanford.nlp.sempre.UnionSemType;
import fig.basic.LispTree;

public class AtomicSemType
extends SemType {
    public final String name;

    public AtomicSemType(String name) {
        if (name == null) {
            throw new RuntimeException("Null name");
        }
        this.name = name;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public SemType meet(SemType that) {
        if (that instanceof TopSemType) {
            return this;
        }
        if (that instanceof UnionSemType) {
            return that.meet(this);
        }
        if (that instanceof AtomicSemType) {
            String name1 = this.name;
            String name2 = ((AtomicSemType)that).name;
            if (name1.equals(name2)) {
                return this;
            }
            if (SemTypeHierarchy.singleton.getSupertypes(name1).contains(name2)) {
                return this;
            }
            if (SemTypeHierarchy.singleton.getSupertypes(name2).contains(name1)) {
                return that;
            }
            return SemType.bottomType;
        }
        return SemType.bottomType;
    }

    @Override
    public SemType apply(SemType that) {
        return SemType.bottomType;
    }

    @Override
    public SemType reverse() {
        return SemType.bottomType;
    }

    @Override
    public LispTree toLispTree() {
        return (LispTree)LispTree.proto.newLeaf(this.name);
    }
}

