/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.BeamParserState;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.Params;
import edu.stanford.nlp.sempre.Parser;
import edu.stanford.nlp.sempre.ParserState;
import edu.stanford.nlp.sempre.Rule;
import edu.stanford.nlp.sempre.Trie;
import fig.basic.IOUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.exec.Execution;

public class BeamParser
extends Parser {
    public static Options opts = new Options();
    Trie trie = new Trie();

    public BeamParser(Parser.Spec spec) {
        super(spec);
        for (Rule rule : this.grammar.rules) {
            this.addRule(rule);
        }
        if (Parser.opts.visualizeChartFilling) {
            this.chartFillOut = IOUtils.openOutAppendEasy((String)Execution.getFile((String)"chartfill"));
        }
    }

    @Override
    public synchronized void addRule(Rule rule) {
        if (!rule.isCatUnary()) {
            this.trie.add(rule);
        }
    }

    @Override
    public ParserState newParserState(Params params, Example ex, boolean computeExpectedCounts) {
        BeamParserState coarseState = null;
        if (Parser.opts.coarsePrune) {
            LogInfo.begin_track((String)"Parser.coarsePrune", (Object[])new Object[0]);
            coarseState = new BeamParserState(this, params, ex, computeExpectedCounts, BeamParserState.Mode.bool, null);
            coarseState.infer();
            coarseState.keepTopDownReachable();
            LogInfo.end_track();
        }
        return new BeamParserState(this, params, ex, computeExpectedCounts, BeamParserState.Mode.full, coarseState);
    }

    public static class Options {
        @Option
        public int maxNewTreesPerSpan = Integer.MAX_VALUE;
    }
}

