/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public class BoundedPriorityQueue<E>
extends TreeSet<E> {
    private static final long serialVersionUID = 5724671156522771658L;
    private int elementsLeft;

    public BoundedPriorityQueue(int maxSize, Comparator<E> comparator) {
        super(comparator);
        this.elementsLeft = maxSize;
    }

    @Override
    public boolean add(E e) {
        if (this.elementsLeft == 0 && this.size() == 0) {
            return false;
        }
        if (this.elementsLeft > 0) {
            boolean added = super.add(e);
            if (added) {
                --this.elementsLeft;
            }
            return added;
        }
        int compared = super.comparator().compare(e, this.last());
        if (compared == -1) {
            this.pollLast();
            super.add(e);
            return true;
        }
        return false;
    }

    public List<E> toList() {
        ArrayList res = new ArrayList();
        for (Object e : this) {
            res.add(e);
        }
        return res;
    }

    public static void main(String[] args) {
        BoundedPriorityQueue<Integer> queue = new BoundedPriorityQueue<Integer>(5, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1.compareTo(o2);
            }
        });
        queue.add(10);
        queue.add(8);
        queue.add(4);
        queue.add(12);
        queue.add(3);
        queue.add(7);
        queue.add(9);
        for (Integer num : queue) {
            System.out.println(num);
        }
    }
}

