/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.google.common.base.Strings;
import edu.stanford.nlp.sempre.BeamParser;
import edu.stanford.nlp.sempre.Executor;
import edu.stanford.nlp.sempre.FeatureExtractor;
import edu.stanford.nlp.sempre.FloatingParser;
import edu.stanford.nlp.sempre.Grammar;
import edu.stanford.nlp.sempre.Params;
import edu.stanford.nlp.sempre.Parser;
import edu.stanford.nlp.sempre.ReinforcementParser;
import edu.stanford.nlp.sempre.SempreUtils;
import edu.stanford.nlp.sempre.ValueEvaluator;
import fig.basic.Option;
import fig.basic.Utils;

public class Builder {
    public static Options opts = new Options();
    public Grammar grammar;
    public Executor executor;
    public ValueEvaluator valueEvaluator;
    public FeatureExtractor extractor;
    public Parser parser;
    public Params params;

    public void build() {
        this.grammar = null;
        this.executor = null;
        this.valueEvaluator = null;
        this.extractor = null;
        this.parser = null;
        this.params = null;
        this.buildUnspecified();
    }

    public void buildUnspecified() {
        if (this.grammar == null) {
            this.grammar = new Grammar();
            this.grammar.read();
            this.grammar.write();
        }
        if (this.executor == null) {
            this.executor = (Executor)Utils.newInstanceHard((String)SempreUtils.resolveClassName(Builder.opts.executor));
        }
        if (this.valueEvaluator == null) {
            this.valueEvaluator = (ValueEvaluator)Utils.newInstanceHard((String)SempreUtils.resolveClassName(Builder.opts.valueEvaluator));
        }
        if (this.extractor == null) {
            this.extractor = new FeatureExtractor(this.executor);
        }
        if (this.parser == null) {
            this.parser = Builder.buildParser(new Parser.Spec(this.grammar, this.extractor, this.executor, this.valueEvaluator));
        }
        if (this.params == null) {
            this.params = new Params();
            if (!Strings.isNullOrEmpty((String)Builder.opts.inParamsPath)) {
                this.params.read(Builder.opts.inParamsPath);
            }
        }
    }

    public static Parser buildParser(Parser.Spec spec) {
        switch (Builder.opts.parser) {
            case "BeamParser": {
                return new BeamParser(spec);
            }
            case "ReinforcementParser": {
                return new ReinforcementParser(spec);
            }
            case "FloatingParser": {
                return new FloatingParser(spec);
            }
        }
        try {
            Class<?> parserClass = Class.forName(SempreUtils.resolveClassName(Builder.opts.parser));
            return (Parser)parserClass.getConstructor(spec.getClass()).newInstance(spec);
        }
        catch (ClassNotFoundException e1) {
            throw new RuntimeException("Illegal parser: " + Builder.opts.parser);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error while instantiating parser: " + Builder.opts.parser + "\n" + e);
        }
    }

    public static class Options {
        @Option
        public String inParamsPath;
        @Option
        public String executor = "JavaExecutor";
        @Option
        public String valueEvaluator = "ExactValueEvaluator";
        @Option
        public String parser = "BeamParser";
    }
}

