/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import edu.stanford.nlp.sempre.Formula;
import edu.stanford.nlp.sempre.Formulas;
import fig.basic.AbstractLispTree;
import fig.basic.LispTree;
import java.util.ArrayList;
import java.util.List;

public class CallFormula
extends Formula {
    public final Formula func;
    public final List<Formula> args;

    public CallFormula(String func, List<Formula> args) {
        this(Formulas.newNameFormula(func), args);
    }

    public CallFormula(Formula func, List<Formula> args) {
        this.func = func;
        this.args = args;
    }

    @Override
    public LispTree toLispTree() {
        LispTree tree = (LispTree)LispTree.proto.newList();
        tree.addChild("call");
        tree.addChild((AbstractLispTree)this.func.toLispTree());
        for (Formula arg : this.args) {
            tree.addChild((AbstractLispTree)arg.toLispTree());
        }
        return tree;
    }

    @Override
    public void forEach(Function<Formula, Boolean> func) {
        if (!((Boolean)func.apply((Object)this)).booleanValue()) {
            this.func.forEach(func);
            for (Formula arg : this.args) {
                arg.forEach(func);
            }
        }
    }

    @Override
    public Formula map(Function<Formula, Formula> transform) {
        Formula result = (Formula)transform.apply((Object)this);
        if (result != null) {
            return result;
        }
        Formula newFunc = this.func.map(transform);
        ArrayList newArgs = Lists.newArrayList();
        for (Formula arg : this.args) {
            newArgs.add(arg.map(transform));
        }
        return new CallFormula(newFunc, (List<Formula>)newArgs);
    }

    @Override
    public List<Formula> mapToList(Function<Formula, List<Formula>> transform, boolean alwaysRecurse) {
        List res = (List)transform.apply((Object)this);
        if (res.isEmpty() || alwaysRecurse) {
            res.addAll(this.func.mapToList(transform, alwaysRecurse));
            for (Formula arg : this.args) {
                res.addAll(arg.mapToList(transform, alwaysRecurse));
            }
        }
        return res;
    }

    @Override
    public boolean equals(Object thatObj) {
        if (!(thatObj instanceof CallFormula)) {
            return false;
        }
        CallFormula that = (CallFormula)thatObj;
        if (!this.func.equals(that.func)) {
            return false;
        }
        return this.args.equals(that.args);
    }

    @Override
    public int computeHashCode() {
        int hash = 2127912214;
        hash = hash * -744332180 + this.func.hashCode();
        hash = hash * -744332180 + this.args.hashCode();
        return hash;
    }
}

