/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.NameValue;
import edu.stanford.nlp.sempre.SemType;
import edu.stanford.nlp.sempre.Value;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CanonicalNames {
    public static final String PREFIX = "fb:";
    public static final String BOOLEAN = "fb:type.boolean";
    public static final String INT = "fb:type.int";
    public static final String FLOAT = "fb:type.float";
    public static final String DATE = "fb:type.datetime";
    public static final String TIME = "fb:type.time";
    public static final String TEXT = "fb:type.text";
    public static final String NUMBER = "fb:type.number";
    public static final String ENTITY = "fb:common.topic";
    public static final String ANY = "fb:type.any";
    public static final List<String> PRIMITIVES = Collections.unmodifiableList(Arrays.asList("fb:type.boolean", "fb:type.int", "fb:type.float", "fb:type.datetime", "fb:type.text", "fb:type.number"));
    public static final String TYPE = "fb:type.object.type";
    public static final String NAME = "fb:type.object.name";
    public static final String STAR = "*";
    public static final Map<String, String> COMPARATOR_REVERSE = new HashMap<String, String>();
    public static final Set<String> COMPARATORS;
    public static final String COLON = ":";
    public static final Map<String, SemType> SPECIAL_SEMTYPES;

    private CanonicalNames() {
    }

    public static boolean isUnary(String s) {
        if (STAR.equals(s)) {
            return true;
        }
        int i = s.indexOf(46);
        if (i == -1) {
            return false;
        }
        return (i = s.indexOf(46, i + 1)) == -1;
    }

    public static boolean isUnary(Value value) {
        return value instanceof NameValue && CanonicalNames.isUnary(((NameValue)value).id);
    }

    public static boolean isBinary(String s) {
        if (COMPARATORS.contains(s) || COLON.equals(s)) {
            return true;
        }
        int i = s.indexOf(46);
        if (i == -1) {
            return false;
        }
        return (i = s.indexOf(46, i + 1)) != -1;
    }

    public static boolean isBinary(Value value) {
        return value instanceof NameValue && CanonicalNames.isBinary(((NameValue)value).id);
    }

    public static boolean isReverseProperty(String property) {
        return property.startsWith("!") && !property.equals("!=");
    }

    public static boolean isReverseProperty(Value value) {
        return value instanceof NameValue && CanonicalNames.isReverseProperty(((NameValue)value).id);
    }

    public static String reverseProperty(String property) {
        if (COMPARATORS.contains(property)) {
            return COMPARATOR_REVERSE.get(property);
        }
        if (CanonicalNames.isReverseProperty(property)) {
            return property.substring(1);
        }
        return "!" + property;
    }

    public static NameValue reverseProperty(Value value) {
        if (!(value instanceof NameValue)) {
            throw new RuntimeException("Cannot call reverseProperty on " + value);
        }
        return new NameValue(CanonicalNames.reverseProperty(((NameValue)value).id));
    }

    static {
        COMPARATOR_REVERSE.put("!=", "!=");
        COMPARATOR_REVERSE.put("<", ">=");
        COMPARATOR_REVERSE.put(">", "<=");
        COMPARATOR_REVERSE.put("<=", ">");
        COMPARATOR_REVERSE.put(">=", "<");
        COMPARATORS = COMPARATOR_REVERSE.keySet();
        SPECIAL_SEMTYPES = new HashMap<String, SemType>();
        SPECIAL_SEMTYPES.put(STAR, SemType.anyType);
        SPECIAL_SEMTYPES.put("!=", SemType.anyAnyFunc);
        SPECIAL_SEMTYPES.put("<", SemType.compareFunc);
        SPECIAL_SEMTYPES.put(">", SemType.compareFunc);
        SPECIAL_SEMTYPES.put("<=", SemType.compareFunc);
        SPECIAL_SEMTYPES.put(">=", SemType.compareFunc);
        SPECIAL_SEMTYPES.put(COLON, SemType.anyAnyFunc);
    }
}

