/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.FloatingParser;
import edu.stanford.nlp.sempre.Grammar;
import edu.stanford.nlp.sempre.Rule;
import fig.basic.LogInfo;
import fig.basic.MapUtils;
import fig.basic.Option;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CatSizeBound {
    public static Options opts = new Options();
    private final int maxFormulaSize;
    private final Map<String, Integer> bound = new HashMap<String, Integer>();

    public CatSizeBound(int maxFormulaSize, Grammar grammar) {
        this(maxFormulaSize, grammar.getRules());
    }

    public CatSizeBound(int maxFormulaSize, List<Rule> rules) {
        this.maxFormulaSize = maxFormulaSize;
        if (!FloatingParser.opts.useSizeInsteadOfDepth) {
            LogInfo.warnings((String)"Currently CatSizeBound is usable only when useSizeInsteadOfDepth = true.", (Object[])new Object[0]);
            return;
        }
        HashMap graph = new HashMap();
        for (Rule rule : rules) {
            if (!Rule.isCat(rule.lhs)) {
                throw new RuntimeException("Non-cat found in LHS of rule " + rule);
            }
            for (String rhsCat : rule.rhs) {
                if (!Rule.isCat(rhsCat)) continue;
                MapUtils.addToSet(graph, (Object)rule.lhs, (Object)rhsCat);
            }
        }
        this.bound.put("$ROOT", maxFormulaSize);
        ArrayDeque<String> queue = new ArrayDeque<String>();
        queue.add("$ROOT");
        while (!queue.isEmpty()) {
            String cat = (String)queue.remove();
            if (!graph.containsKey(cat)) continue;
            for (String rhsCat : (Set)graph.get(cat)) {
                if (this.bound.containsKey(rhsCat)) continue;
                this.bound.put(rhsCat, this.bound.get(cat) - 1);
                queue.add(rhsCat);
            }
        }
        if (CatSizeBound.opts.verbose >= 1) {
            LogInfo.begin_track((String)"CatSizeBound: distances", (Object[])new Object[0]);
            for (Map.Entry<String, Integer> entry : this.bound.entrySet()) {
                LogInfo.logs((String)"%25s : %2d", (Object[])new Object[]{entry.getKey(), entry.getValue()});
            }
            LogInfo.end_track();
        }
    }

    public int getBound(String cat) {
        return this.bound.getOrDefault(cat, this.maxFormulaSize);
    }

    public static class Options {
        @Option(gloss="verbosity")
        public int verbose = 0;
    }
}

