/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.ErrorValue;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.Params;
import edu.stanford.nlp.sempre.Parser;
import edu.stanford.nlp.sempre.ParserState;
import fig.basic.LogInfo;
import fig.basic.MapUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ChartParserState
extends ParserState {
    protected final Map<String, List<Derivation>>[][] chart;
    protected List<CatSpan> chartFillingList = new ArrayList<CatSpan>();
    protected String[][] phrases;

    public ChartParserState(Parser parser, Params params, Example ex, boolean computeExpectedCounts) {
        super(parser, params, ex, computeExpectedCounts);
        this.chart = (HashMap[][])Array.newInstance(HashMap.class, this.numTokens, this.numTokens + 1);
        this.phrases = new String[this.numTokens][this.numTokens + 1];
        for (int start = 0; start < this.numTokens; ++start) {
            StringBuilder sb = new StringBuilder();
            for (int end = start + 1; end <= this.numTokens; ++end) {
                if (end - start > 1) {
                    sb.append(' ');
                }
                sb.append(this.ex.languageInfo.tokens.get(end - 1));
                this.phrases[start][end] = sb.toString();
                this.chart[start][end] = new HashMap<String, List<Derivation>>();
            }
        }
    }

    public void clearChart() {
        for (int start = 0; start < this.numTokens; ++start) {
            for (int end = start + 1; end <= this.numTokens; ++end) {
                this.chart[start][end].clear();
            }
        }
    }

    protected void setPredDerivations() {
        this.predDerivations.clear();
        this.predDerivations.addAll((Collection)MapUtils.get(this.chart[0][this.numTokens], (Object)"$ROOT", Derivation.emptyList));
    }

    private void visualizeChart() {
        for (int len = 1; len <= this.numTokens; ++len) {
            int i = 0;
            while (i + len <= this.numTokens) {
                for (String cat : this.chart[i][i + len].keySet()) {
                    List<Derivation> derivations = this.chart[i][i + len].get(cat);
                    for (Derivation deriv : derivations) {
                        LogInfo.logs((String)"ParserState.visualize: %s(%s:%s): %s", (Object[])new Object[]{cat, i, i + len, deriv});
                    }
                }
                ++i;
            }
        }
    }

    protected void addToChart(Derivation deriv) {
        if (this.parser.verbose(3)) {
            LogInfo.logs((String)"addToChart %s: %s", (Object[])new Object[]{deriv.cat, deriv});
        }
        if (Parser.opts.pruneErrorValues && deriv.value instanceof ErrorValue) {
            return;
        }
        List<Derivation> derivations = this.chart[deriv.start][deriv.end].get(deriv.cat);
        if (this.chart[deriv.start][deriv.end].get(deriv.cat) == null) {
            derivations = new ArrayList<Derivation>();
            this.chart[deriv.start][deriv.end].put(deriv.cat, derivations);
        }
        derivations.add(deriv);
        ++this.totalGeneratedDerivs;
        if (Parser.opts.visualizeChartFilling) {
            this.chartFillingList.add(new CatSpan(deriv.start, deriv.end, deriv.cat));
        }
    }

    public Map<String, List<Derivation>>[][] getChart() {
        return this.chart;
    }

    public static class ChartFillingData {
        @JsonProperty
        public final String id;
        @JsonProperty
        public final String utterance;
        @JsonProperty
        public final int numOfTokens;
        @JsonProperty
        public final List<CatSpan> catSpans;

        @JsonCreator
        public ChartFillingData(@JsonProperty(value="id") String id, @JsonProperty(value="catspans") List<CatSpan> catSpans, @JsonProperty(value="utterance") String utterance, @JsonProperty(value="numOfTokens") int numOfTokens) {
            this.id = id;
            this.utterance = utterance;
            this.numOfTokens = numOfTokens;
            this.catSpans = catSpans;
        }
    }

    public static class CatSpan {
        @JsonProperty
        public final int start;
        @JsonProperty
        public final int end;
        @JsonProperty
        public final String cat;

        @JsonCreator
        public CatSpan(@JsonProperty(value="start") int start, @JsonProperty(value="end") int end, @JsonProperty(value="cat") String cat) {
            this.start = start;
            this.end = end;
            this.cat = cat;
        }
    }
}

