/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.DerivationStream;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.SemanticFn;
import edu.stanford.nlp.sempre.SingleDerivationStream;
import fig.basic.LispTree;

public class ConcatFn
extends SemanticFn {
    String delim;

    public ConcatFn() {
    }

    public ConcatFn(String delim) {
        this.delim = delim;
    }

    @Override
    public void init(LispTree tree) {
        super.init(tree);
        this.delim = ((LispTree)tree.child((int)1)).value;
    }

    @Override
    public DerivationStream call(Example ex, final SemanticFn.Callable c) {
        return new SingleDerivationStream(){

            @Override
            public Derivation createDerivation() {
                StringBuilder out = new StringBuilder();
                for (int i = 0; i < c.getChildren().size(); ++i) {
                    if (i > 0) {
                        out.append(ConcatFn.this.delim);
                    }
                    out.append(c.childStringValue(i));
                }
                return new Derivation.Builder().withCallable(c).withStringFormulaFrom(out.toString()).createDerivation();
            }
        };
    }
}

