/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.DerivationStream;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.FeatureExtractor;
import edu.stanford.nlp.sempre.Formula;
import edu.stanford.nlp.sempre.Formulas;
import edu.stanford.nlp.sempre.SemType;
import edu.stanford.nlp.sempre.SemanticFn;
import edu.stanford.nlp.sempre.SingleDerivationStream;
import edu.stanford.nlp.sempre.TypeInference;
import fig.basic.AbstractLispTree;
import fig.basic.LispTree;

public class ConstantFn
extends SemanticFn {
    Formula formula;
    SemType type;

    public ConstantFn() {
    }

    public ConstantFn(Formula formula) {
        this.init((LispTree)LispTree.proto.newList("ConstantFn", (AbstractLispTree)formula.toLispTree()));
    }

    @Override
    public void init(LispTree tree) {
        super.init(tree);
        this.formula = Formulas.fromLispTree((LispTree)tree.child(1));
        this.type = 2 < tree.children.size() ? SemType.fromLispTree((LispTree)tree.child(2)) : TypeInference.inferType(this.formula);
        if (!this.type.isValid()) {
            throw new RuntimeException("ConstantFn: " + this.formula + " does not type check");
        }
    }

    @Override
    public DerivationStream call(final Example ex, final SemanticFn.Callable c) {
        return new SingleDerivationStream(){

            @Override
            public Derivation createDerivation() {
                Derivation res = new Derivation.Builder().withCallable(c).formula(ConstantFn.this.formula).type(ConstantFn.this.type).createDerivation();
                if (FeatureExtractor.containsDomain("constant") && c.getStart() != -1) {
                    res.addFeature("constant", ex.phraseString(c.getStart(), c.getEnd()) + " --- " + ConstantFn.this.formula.toString());
                }
                return res;
            }
        };
    }
}

