/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.ContextValue;
import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.DerivationStream;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.Formula;
import edu.stanford.nlp.sempre.Formulas;
import edu.stanford.nlp.sempre.MultipleDerivationStream;
import edu.stanford.nlp.sempre.SemType;
import edu.stanford.nlp.sempre.SemanticFn;
import edu.stanford.nlp.sempre.TypeInference;
import fig.basic.LispTree;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ContextFn
extends SemanticFn {
    private int depth;
    private SemType restrictType = SemType.topType;
    private Set<SemType> forbiddenTypes = new HashSet<SemType>();

    @Override
    public void init(LispTree tree) {
        super.init(tree);
        for (int i = 1; i < tree.children.size(); ++i) {
            LispTree arg = (LispTree)tree.child(i);
            if ("type".equals(((LispTree)arg.child((int)0)).value)) {
                this.restrictType = SemType.fromLispTree((LispTree)arg.child(1));
                continue;
            }
            if ("depth".equals(((LispTree)arg.child((int)0)).value)) {
                this.depth = Integer.parseInt(((LispTree)arg.child((int)1)).value);
                continue;
            }
            if ("forbidden".equals(((LispTree)arg.child((int)0)).value)) {
                this.forbiddenTypes.add(SemType.fromLispTree((LispTree)arg.child(1)));
                continue;
            }
            throw new RuntimeException("Unknown argument: " + arg);
        }
    }

    @Override
    public DerivationStream call(final Example ex, final SemanticFn.Callable c) {
        return new MultipleDerivationStream(){
            int index = 0;
            List<Formula> formulas;

            @Override
            public Derivation createDerivation() {
                if (ex.context == null) {
                    return null;
                }
                if (this.formulas == null) {
                    this.formulas = new ArrayList<Formula>();
                    for (int i = ex.context.exchanges.size() - 1; i >= 0; --i) {
                        ContextValue.Exchange e = ex.context.exchanges.get(i);
                        this.extractFormulas(e.formula.toLispTree());
                    }
                }
                if (this.index >= this.formulas.size()) {
                    return null;
                }
                Formula formula = this.formulas.get(this.index++);
                for (SemType forbiddenType : ContextFn.this.forbiddenTypes) {
                    if (!TypeInference.inferType(formula).meet(forbiddenType).isValid()) continue;
                    return null;
                }
                return new Derivation.Builder().withCallable(c).formula(formula).type(TypeInference.inferType(formula)).createDerivation();
            }

            private void addFormula(Formula formula) {
                if (this.formulas.contains(formula)) {
                    return;
                }
                this.formulas.add(formula);
            }

            private void extractFormulas(LispTree formula) {
                if (this.correctDepth(formula, 0) && this.typeCheck(formula)) {
                    this.addFormula(Formulas.fromLispTree(formula));
                }
                if (formula.isLeaf()) {
                    return;
                }
                for (LispTree child : formula.children) {
                    this.extractFormulas(child);
                }
            }

            private boolean correctDepth(LispTree formula, int currentLevel) {
                if (formula.isLeaf()) {
                    return currentLevel == ContextFn.this.depth;
                }
                boolean isCorrect = true;
                for (LispTree child : formula.children) {
                    isCorrect = isCorrect && this.correctDepth(child, currentLevel + 1);
                }
                return isCorrect;
            }

            private boolean typeCheck(LispTree treeFormula) {
                Formula formula = Formulas.fromLispTree(treeFormula);
                SemType type = TypeInference.inferType(formula);
                type = ContextFn.this.restrictType.meet(type);
                return type.isValid();
            }
        };
    }
}

