/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import edu.stanford.nlp.sempre.DateValue;
import edu.stanford.nlp.sempre.Formula;
import edu.stanford.nlp.sempre.Formulas;
import edu.stanford.nlp.sempre.KnowledgeGraph;
import edu.stanford.nlp.sempre.Value;
import edu.stanford.nlp.sempre.Values;
import fig.basic.AbstractLispTree;
import fig.basic.LispTree;
import java.util.ArrayList;
import java.util.List;

public class ContextValue
extends Value {
    public final String user;
    public final DateValue date;
    public final List<Exchange> exchanges;
    public final KnowledgeGraph graph;

    public ContextValue withDate(DateValue newDate) {
        return new ContextValue(this.user, newDate, this.exchanges, this.graph);
    }

    public ContextValue withNewExchange(List<Exchange> newExchanges) {
        return new ContextValue(this.user, this.date, newExchanges, this.graph);
    }

    public ContextValue withGraph(KnowledgeGraph newGraph) {
        return new ContextValue(this.user, this.date, this.exchanges, newGraph);
    }

    public ContextValue(String user, DateValue date, List<Exchange> exchanges, KnowledgeGraph graph) {
        this.user = user;
        this.date = date;
        this.exchanges = exchanges;
        this.graph = graph;
    }

    public ContextValue(String user, DateValue date, List<Exchange> exchanges) {
        this(user, date, exchanges, null);
    }

    public ContextValue(KnowledgeGraph graph) {
        this(null, null, new ArrayList<Exchange>(), graph);
    }

    public ContextValue(LispTree tree) {
        String user = null;
        DateValue date = null;
        KnowledgeGraph graph = null;
        this.exchanges = new ArrayList<Exchange>();
        for (int i = 1; i < tree.children.size(); ++i) {
            String key = ((LispTree)((LispTree)tree.child((int)i)).child((int)0)).value;
            if (key.equals("user")) {
                user = ((LispTree)((LispTree)tree.child((int)i)).child((int)1)).value;
                continue;
            }
            if (key.equals("date")) {
                date = new DateValue((LispTree)tree.child(i));
                continue;
            }
            if (key.equals("graph")) {
                graph = KnowledgeGraph.fromLispTree((LispTree)tree.child(i));
                continue;
            }
            if (key.equals("exchange")) {
                this.exchanges.add(new Exchange((LispTree)tree.child(i)));
                continue;
            }
            throw new RuntimeException("Invalid: " + tree.child(i));
        }
        this.user = user;
        this.date = date;
        this.graph = graph;
    }

    @Override
    public LispTree toLispTree() {
        LispTree tree = (LispTree)LispTree.proto.newList();
        tree.addChild("context");
        if (this.user != null) {
            tree.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList("user", this.user)));
        }
        if (this.date != null) {
            tree.addChild((AbstractLispTree)this.date.toLispTree());
        }
        if (this.graph != null) {
            tree.addChild((AbstractLispTree)this.graph.toShortLispTree());
        }
        for (Exchange e : this.exchanges) {
            tree.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList("exchange", (AbstractLispTree)e.toLispTree())));
        }
        return tree;
    }

    @Override
    public int hashCode() {
        int hash = 2127912214;
        hash = hash * -744332180 + this.user.hashCode();
        hash = hash * -744332180 + this.date.hashCode();
        hash = hash * -744332180 + this.exchanges.hashCode();
        hash = hash * -744332180 + this.graph.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextValue that = (ContextValue)o;
        if (!this.user.equals(that.user)) {
            return false;
        }
        if (!this.date.equals(that.date)) {
            return false;
        }
        if (!this.exchanges.equals(that.exchanges)) {
            return false;
        }
        return this.graph.equals(that.graph);
    }

    @Override
    @JsonValue
    public String toString() {
        return this.toLispTree().toString();
    }

    @JsonCreator
    public static ContextValue fromString(String str) {
        return new ContextValue((LispTree)LispTree.proto.parseFromString(str));
    }

    public static class Exchange {
        public final String utterance;
        public final Formula formula;
        public final Value value;

        public Exchange(String utterance, Formula formula, Value value) {
            this.utterance = utterance;
            this.formula = formula;
            this.value = value;
        }

        public Exchange(LispTree tree) {
            this.utterance = ((LispTree)tree.child((int)1)).value;
            this.formula = Formulas.fromLispTree((LispTree)tree.child(2));
            this.value = Values.fromLispTree((LispTree)tree.child(3));
        }

        public LispTree toLispTree() {
            LispTree tree = (LispTree)LispTree.proto.newList();
            tree.addChild("exchange");
            tree.addChild(this.utterance);
            tree.addChild((AbstractLispTree)this.formula.toLispTree());
            tree.addChild((AbstractLispTree)this.value.toLispTree());
            return tree;
        }

        public String toString() {
            return this.toLispTree().toString();
        }
    }
}

