/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.DateValue;
import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.DerivationStream;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.SemType;
import edu.stanford.nlp.sempre.SemanticFn;
import edu.stanford.nlp.sempre.SingleDerivationStream;
import edu.stanford.nlp.sempre.ValueFormula;

public class DateFn
extends SemanticFn {
    @Override
    public DerivationStream call(final Example ex, final SemanticFn.Callable c) {
        return new SingleDerivationStream(){

            @Override
            public Derivation createDerivation() {
                String value = ex.languageInfo.getNormalizedNerSpan("DATE", c.getStart(), c.getEnd());
                if (value == null) {
                    return null;
                }
                DateValue dateValue = DateValue.parseDateValue(value);
                if (dateValue == null) {
                    return null;
                }
                return new Derivation.Builder().withCallable(c).formula(new ValueFormula<DateValue>(dateValue)).type(SemType.dateType).createDerivation();
            }
        };
    }
}

