/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.DerivationStream;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.Formula;
import edu.stanford.nlp.sempre.JoinFormula;
import edu.stanford.nlp.sempre.MergeFormula;
import edu.stanford.nlp.sempre.MultipleDerivationStream;
import edu.stanford.nlp.sempre.NameValue;
import edu.stanford.nlp.sempre.NumberValue;
import edu.stanford.nlp.sempre.SemType;
import edu.stanford.nlp.sempre.SemanticFn;
import edu.stanford.nlp.sempre.ValueFormula;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateRangeFn
extends SemanticFn {
    @Override
    public DerivationStream call(Example ex, SemanticFn.Callable c) {
        return new LazyDateRangeFnDerivs(ex, c);
    }

    public static class LazyDateRangeFnDerivs
    extends MultipleDerivationStream {
        Example ex;
        SemanticFn.Callable c;
        int index = 0;
        List<Formula> formulas;
        private static final Pattern YEAR_RANGE = Pattern.compile("^(\\d+0+)\\s*'?s$");

        public LazyDateRangeFnDerivs(Example ex, SemanticFn.Callable c) {
            this.ex = ex;
            this.c = c;
        }

        @Override
        public Derivation createDerivation() {
            if (this.formulas == null) {
                this.populateFormulas();
            }
            if (this.index >= this.formulas.size()) {
                return null;
            }
            Formula formula = this.formulas.get(this.index++);
            return new Derivation.Builder().withCallable(this.c).formula(formula).type(SemType.numberType).createDerivation();
        }

        private void populateFormulas() {
            this.formulas = new ArrayList<Formula>();
            String query = this.c.childStringValue(0);
            Matcher matcher = YEAR_RANGE.matcher(query);
            if (!matcher.matches()) {
                return;
            }
            int year = Integer.parseInt(matcher.group(1));
            int range = 10;
            while (year % range == 0) {
                this.formulas.add(new MergeFormula(MergeFormula.Mode.and, new JoinFormula(new ValueFormula<NameValue>(new NameValue("<")), new ValueFormula<NumberValue>(new NumberValue(year + range))), new JoinFormula(new ValueFormula<NameValue>(new NameValue(">=")), new ValueFormula<NumberValue>(new NumberValue(year)))));
                range *= 10;
            }
        }
    }
}

