/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Value;
import fig.basic.LispTree;
import java.util.Calendar;

public class DateValue
extends Value {
    public final int year;
    public final int month;
    public final int day;

    public static DateValue parseDateValue(String dateStr) {
        String[] dateParts;
        int t;
        if (dateStr.equals("PRESENT_REF")) {
            return null;
        }
        if (dateStr.startsWith("OFFSET")) {
            return null;
        }
        int year = -1;
        int month = -1;
        int day = -1;
        boolean isBC = dateStr.startsWith("-");
        if (isBC) {
            dateStr = dateStr.substring(1);
        }
        if ((t = dateStr.indexOf(84)) != -1) {
            dateStr = dateStr.substring(0, t);
        }
        if (dateStr.indexOf(84) != -1) {
            dateStr = dateStr.substring(0, dateStr.indexOf(84));
        }
        if ((dateParts = dateStr.split("-")).length > 3) {
            throw new RuntimeException("Date has more than 3 parts: " + dateStr);
        }
        if (dateParts.length >= 1) {
            year = DateValue.parseIntRobust(dateParts[0]) * (isBC ? -1 : 1);
        }
        if (dateParts.length >= 2) {
            month = DateValue.parseIntRobust(dateParts[1]);
        }
        if (dateParts.length >= 3) {
            day = DateValue.parseIntRobust(dateParts[2]);
        }
        return new DateValue(year, month, day);
    }

    private static int parseIntRobust(String i) {
        int val;
        try {
            val = Integer.parseInt(i);
        }
        catch (NumberFormatException ex) {
            val = -1;
        }
        return val;
    }

    public static DateValue now() {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        return new DateValue(year, month, day);
    }

    public DateValue(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public DateValue(LispTree tree) {
        this.year = Integer.valueOf(((LispTree)tree.child((int)1)).value);
        this.month = Integer.valueOf(((LispTree)tree.child((int)2)).value);
        this.day = Integer.valueOf(((LispTree)tree.child((int)3)).value);
    }

    @Override
    public LispTree toLispTree() {
        LispTree tree = (LispTree)LispTree.proto.newList();
        tree.addChild("date");
        tree.addChild(String.valueOf(this.year));
        tree.addChild(String.valueOf(this.month));
        tree.addChild(String.valueOf(this.day));
        return tree;
    }

    @Override
    public String sortString() {
        return "" + this.year + "/" + this.month + "/" + this.day;
    }

    public String isoString() {
        return "" + (this.year == -1 ? "xxxx" : String.format("%04d", this.year)) + "-" + (this.month == -1 ? "xx" : String.format("%02d", this.month)) + "-" + (this.day == -1 ? "xx" : String.format("%02d", this.day));
    }

    @Override
    public int hashCode() {
        int hash = 2127912214;
        hash = hash * -744332180 + this.year;
        hash = hash * -744332180 + this.month;
        hash = hash * -744332180 + this.day;
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateValue that = (DateValue)o;
        if (this.year != that.year) {
            return false;
        }
        if (this.month != that.month) {
            return false;
        }
        return this.day == that.day;
    }
}

