/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.AggregateFormula;
import edu.stanford.nlp.sempre.CanonicalNames;
import edu.stanford.nlp.sempre.ContextValue;
import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.DerivationPruner;
import edu.stanford.nlp.sempre.DerivationPruningComputer;
import edu.stanford.nlp.sempre.ErrorValue;
import edu.stanford.nlp.sempre.Formula;
import edu.stanford.nlp.sempre.LambdaFormula;
import edu.stanford.nlp.sempre.ListValue;
import edu.stanford.nlp.sempre.MergeFormula;
import edu.stanford.nlp.sempre.SemType;
import edu.stanford.nlp.sempre.SuperlativeFormula;
import edu.stanford.nlp.sempre.TypeInference;
import edu.stanford.nlp.sempre.Value;
import edu.stanford.nlp.sempre.ValueFormula;
import fig.basic.LogInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class DefaultDerivationPruningComputer
extends DerivationPruningComputer {
    public static final String atomic = "atomic";
    public static final String emptyDenotation = "emptyDenotation";
    public static final String nonLambdaError = "nonLambdaError";
    public static final String tooManyValues = "tooManyValues";
    public static final String doubleSummarizers = "doubleSummarizers";
    public static final String sameMerge = "sameMerge";
    public static final String mistypedMerge = "mistypedMerge";
    public static final String unsortedMerge = "unsortedMerge";
    public static final String badSummarizerHead = "badSummarizerHead";

    public DefaultDerivationPruningComputer(DerivationPruner pruner) {
        super(pruner);
    }

    @Override
    public Collection<String> getAllStrategyNames() {
        return Arrays.asList(atomic, emptyDenotation, nonLambdaError, tooManyValues, doubleSummarizers, sameMerge, mistypedMerge, unsortedMerge, badSummarizerHead);
    }

    @Override
    public String isPrunedWithoutExecution(Derivation deriv) {
        if (this.containsStrategy(atomic) && deriv.isRoot(this.pruner.ex.numTokens()) && deriv.formula instanceof ValueFormula) {
            return atomic;
        }
        return null;
    }

    @Override
    public String isPrunedGeneral(Derivation deriv) {
        if (this.containsStrategy(emptyDenotation) && deriv.value instanceof ListValue && ((ListValue)deriv.value).values.isEmpty()) {
            return emptyDenotation;
        }
        if (this.containsStrategy(nonLambdaError) && !this.isLambdaFormula(deriv.formula) && deriv.value instanceof ErrorValue) {
            if (DerivationPruner.opts.pruningVerbosity >= 5) {
                LogInfo.logs((String)"NonLambdaError: %s => %s", (Object[])new Object[]{deriv.formula, deriv.value});
            }
            return nonLambdaError;
        }
        if (this.containsStrategy(tooManyValues) && deriv.isRoot(this.pruner.ex.numTokens()) && (!(deriv.value instanceof ListValue) || ((ListValue)deriv.value).values.size() > DerivationPruner.opts.maxNumValues)) {
            return tooManyValues;
        }
        return null;
    }

    private boolean isLambdaFormula(Formula formula) {
        if (formula instanceof LambdaFormula) {
            return true;
        }
        return formula instanceof ValueFormula && CanonicalNames.isBinary(((ValueFormula)formula).value);
    }

    @Override
    public String isPrunedRecursive(Derivation deriv, Formula subformula, Map<String, Object> state) {
        MergeFormula merge;
        Formula innerFormula;
        if (this.containsStrategy(doubleSummarizers)) {
            innerFormula = null;
            if (subformula instanceof SuperlativeFormula) {
                innerFormula = ((SuperlativeFormula)subformula).head;
            } else if (subformula instanceof AggregateFormula) {
                innerFormula = ((AggregateFormula)subformula).child;
            }
            if (innerFormula != null && (innerFormula instanceof SuperlativeFormula || innerFormula instanceof AggregateFormula)) {
                return doubleSummarizers;
            }
        }
        if (this.containsStrategy(sameMerge) && subformula instanceof MergeFormula) {
            merge = (MergeFormula)subformula;
            if (merge.child1.equals(merge.child2)) {
                return sameMerge;
            }
        }
        if (this.containsStrategy(mistypedMerge) && subformula instanceof MergeFormula) {
            SemType type2;
            merge = (MergeFormula)subformula;
            SemType type1 = TypeInference.inferType(merge.child1, true);
            if (!type1.meet(type2 = TypeInference.inferType(merge.child2, true)).isValid()) {
                return mistypedMerge;
            }
        }
        if (this.containsStrategy(unsortedMerge) && subformula instanceof MergeFormula) {
            String child2;
            merge = (MergeFormula)subformula;
            String child1 = merge.child1.toString();
            if (child1.compareTo(child2 = merge.child2.toString()) >= 0) {
                return unsortedMerge;
            }
        }
        if (this.containsStrategy(badSummarizerHead) && DerivationPruner.opts.ensureExecuted) {
            innerFormula = null;
            boolean isCount = false;
            if (subformula instanceof SuperlativeFormula) {
                innerFormula = ((SuperlativeFormula)subformula).head;
            } else if (subformula instanceof AggregateFormula) {
                innerFormula = ((AggregateFormula)subformula).child;
                if (((AggregateFormula)subformula).mode == AggregateFormula.Mode.count) {
                    isCount = true;
                }
            }
            if (innerFormula != null) {
                try {
                    int size;
                    TypeInference.inferType(innerFormula);
                    Value innerValue = this.pruner.parser.executor.execute((Formula)innerFormula, (ContextValue)this.pruner.ex.context).value;
                    if (!(!(innerValue instanceof ListValue) || (size = ((ListValue)innerValue).values.size()) != 0 && (size != 1 || DerivationPruner.opts.allowCountOne && isCount))) {
                        return badSummarizerHead;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

