/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Formula;
import edu.stanford.nlp.sempre.Rule;

class DerivInfo {
    public final String cat;
    public final int start;
    public final int end;
    public final Formula formula;
    public final Rule rule;

    DerivInfo(String cat, int start, int end, Formula formula, Rule rule) {
        this.cat = cat;
        this.start = start;
        this.end = end;
        this.formula = formula;
        this.rule = rule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DerivInfo derivInfo = (DerivInfo)o;
        if (this.end != derivInfo.end) {
            return false;
        }
        if (this.start != derivInfo.start) {
            return false;
        }
        if (this.cat != null ? !this.cat.equals(derivInfo.cat) : derivInfo.cat != null) {
            return false;
        }
        if (this.formula != null ? !this.formula.equals(derivInfo.formula) : derivInfo.formula != null) {
            return false;
        }
        return !(this.rule == null ? derivInfo.rule != null : !this.rule.equals(derivInfo.rule));
    }

    public int hashCode() {
        int result = this.cat != null ? this.cat.hashCode() : 0;
        result = 31 * result + this.start;
        result = 31 * result + this.end;
        result = 31 * result + (this.formula != null ? this.formula.hashCode() : 0);
        result = 31 * result + (this.rule != null ? this.rule.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.cat + "(" + this.start + "," + this.end + ") " + this.formula.toString();
    }
}

