/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.google.common.collect.Sets;
import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.FeatureComputer;
import edu.stanford.nlp.sempre.FeatureExtractor;
import fig.basic.MapUtils;
import fig.basic.Option;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DerivOpCountFeatureComputer
implements FeatureComputer {
    public static Options opts = new Options();
    public static final String entityCat = "$Entity";
    public static final String unaryCat = "$Unary";
    public static final String binaryCat = "$Binary";
    public static final String joinFn = "JoinFn";
    public static final String mergeFn = "MergeFn";
    public static final String bridgeFn = "BridgeFn";
    public static Set<String> featureNames = Sets.newHashSet((Object[])new String[]{"$Entity", "$Unary", "$Binary", "JoinFn", "MergeFn", "BridgeFn"});

    @Override
    public void extractLocal(Example ex, Derivation deriv) {
        if (!FeatureExtractor.containsDomain("opCount")) {
            return;
        }
        if (!deriv.isRoot(ex.numTokens())) {
            return;
        }
        HashMap<String, Integer> opCounter = new HashMap<String, Integer>();
        this.extractOperationsRecurse(deriv, opCounter);
        this.addFeatures(deriv, opCounter);
    }

    private void extractOperationsRecurse(Derivation deriv, Map<String, Integer> opCounter) {
        if (deriv.children.isEmpty()) {
            return;
        }
        MapUtils.incr(opCounter, (Object)deriv.rule.lhs);
        MapUtils.incr(opCounter, (Object)deriv.rule.sem.getClass().getSimpleName());
        for (Derivation child : deriv.children) {
            this.extractOperationsRecurse(child, opCounter);
        }
    }

    private void addFeatures(Derivation deriv, Map<String, Integer> opCounter) {
        for (String feature : DerivOpCountFeatureComputer.opts.countBasicOnly ? featureNames : opCounter.keySet()) {
            deriv.addFeature("opCount", "count(" + feature + ")=" + MapUtils.get(opCounter, (Object)feature, (Object)0));
        }
    }

    public static class Options {
        @Option(gloss="Count only basic categories and SemanticFns")
        public boolean countBasicOnly = true;
    }
}

