/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.AllFeatureMatcher;
import edu.stanford.nlp.sempre.ContextValue;
import edu.stanford.nlp.sempre.ExactFeatureMatcher;
import edu.stanford.nlp.sempre.Executor;
import edu.stanford.nlp.sempre.FeatureMatcher;
import edu.stanford.nlp.sempre.FeatureVector;
import edu.stanford.nlp.sempre.Formula;
import edu.stanford.nlp.sempre.Formulas;
import edu.stanford.nlp.sempre.HasScore;
import edu.stanford.nlp.sempre.ListValue;
import edu.stanford.nlp.sempre.Params;
import edu.stanford.nlp.sempre.Rule;
import edu.stanford.nlp.sempre.SemType;
import edu.stanford.nlp.sempre.SemanticFn;
import edu.stanford.nlp.sempre.SempreUtils;
import edu.stanford.nlp.sempre.StringValue;
import edu.stanford.nlp.sempre.Value;
import edu.stanford.nlp.sempre.ValueFormula;
import fig.basic.AbstractLispTree;
import fig.basic.Evaluation;
import fig.basic.LispTree;
import fig.basic.LogInfo;
import fig.basic.MapUtils;
import fig.basic.NumUtils;
import fig.basic.Option;
import fig.basic.StopWatchSet;
import fig.basic.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Derivation
implements SemanticFn.Callable,
HasScore {
    public static Options opts = new Options();
    public final String cat;
    public final int start;
    public final int end;
    public String canonicalUtterance;
    public boolean allAnchored = true;
    private int[] numAnchors;
    public GrammarInfo grammarInfo = new GrammarInfo();
    public final Rule rule;
    public final List<Derivation> children;
    public final Formula formula;
    public final SemType type;
    private List<String> localChoices;
    private final FeatureVector localFeatureVector;
    double score = Double.NaN;
    double prob = Double.NaN;
    private Map<String, Object> tempState;
    public Value value;
    public Evaluation executorStats;
    public double compatibility = Double.NaN;
    int maxBeamPosition = -1;
    int maxUnsortedBeamPosition = -1;
    int preSortBeamPosition = -1;
    int postSortBeamPosition = -1;
    int hashCode = -1;
    long creationIndex;
    public static long numCreated = 0L;
    public static final Comparator<Derivation> derivScoreComparator = (Comparator)Utils.newInstanceHard((String)SempreUtils.resolveClassName("Derivation$" + Derivation.opts.derivComparator));
    public static final List<Derivation> emptyList = Collections.emptyList();

    Derivation(String cat, int start, int end, Rule rule, List<Derivation> children, Formula formula, SemType type, FeatureVector localFeatureVector, double score, Value value, Evaluation executorStats, double compatibility, double prob, String canonicalUtterance) {
        this.cat = cat;
        this.start = start;
        this.end = end;
        this.rule = rule;
        this.children = children;
        this.formula = formula;
        this.type = type;
        this.localFeatureVector = localFeatureVector;
        this.score = score;
        this.value = value;
        this.executorStats = executorStats;
        this.compatibility = compatibility;
        this.prob = prob;
        this.canonicalUtterance = canonicalUtterance;
        this.creationIndex = numCreated++;
    }

    public Formula getFormula() {
        return this.formula;
    }

    @Override
    public double getScore() {
        return this.score;
    }

    public double getProb() {
        return this.prob;
    }

    public double getCompatibility() {
        return this.compatibility;
    }

    @Override
    public List<Derivation> getChildren() {
        return this.children;
    }

    public Value getValue() {
        return this.value;
    }

    public boolean isFeaturizedAndScored() {
        return !Double.isNaN(this.score);
    }

    public boolean isExecuted() {
        return this.value != null;
    }

    public int getMaxBeamPosition() {
        return this.maxBeamPosition;
    }

    @Override
    public String getCat() {
        return this.cat;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    public boolean containsIndex(int i) {
        return i < this.end && i >= this.start;
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }

    public Evaluation getExecutorStats() {
        return this.executorStats;
    }

    public FeatureVector getLocalFeatureVector() {
        return this.localFeatureVector;
    }

    @Override
    public Derivation child(int i) {
        return this.children.get(i);
    }

    @Override
    public String childStringValue(int i) {
        return Formulas.getString(this.children.get((int)i).formula);
    }

    public boolean isRoot(int numTokens) {
        return this.cat.equals("$ROOT") && (this.start == 0 && this.end == numTokens || this.start == -1);
    }

    public boolean isRootCat() {
        return this.cat.equals("$ROOT");
    }

    public void addFeature(String domain, String name) {
        this.addFeature(domain, name, 1.0);
    }

    public void addFeature(String domain, String name, double value) {
        this.localFeatureVector.add(domain, name, value);
    }

    public void addHistogramFeature(String domain, String name, double value, int initBinSize, int numBins, boolean exp) {
        this.localFeatureVector.addHistogram(domain, name, value, initBinSize, numBins, exp);
    }

    public void addFeatureWithBias(String domain, String name, double value) {
        this.localFeatureVector.addWithBias(domain, name, value);
    }

    public void addFeatures(FeatureVector fv) {
        this.localFeatureVector.add(fv);
    }

    public double localScore(Params params) {
        return this.localFeatureVector.dotProduct(params) + (this.allAnchored() ? Derivation.opts.anchoredBonus : 0.0);
    }

    public void clearFeatures() {
        this.localFeatureVector.clear();
    }

    public double computeScore(Params params) {
        this.score = this.localScore(params);
        if (this.children != null) {
            for (Derivation child : this.children) {
                this.score += child.computeScore(params);
            }
        }
        return this.score;
    }

    public double computeScoreLocal(Params params) {
        this.score = this.localScore(params);
        if (this.children != null) {
            for (Derivation child : this.children) {
                this.score += child.score;
            }
        }
        return this.score;
    }

    public void ensureExecuted(Executor executor, ContextValue context) {
        if (this.isExecuted()) {
            return;
        }
        StopWatchSet.begin((String)"Executor.execute");
        if (Derivation.opts.showExecutions) {
            LogInfo.logs((String)"%s - %s", (Object[])new Object[]{this.canonicalUtterance, this.formula});
        }
        Executor.Response response = executor.execute(this.formula, context);
        StopWatchSet.end();
        this.value = response.value;
        this.executorStats = response.stats;
    }

    public LispTree toLispTree() {
        LispTree tree = (LispTree)LispTree.proto.newList();
        tree.addChild("derivation");
        if (this.formula != null) {
            tree.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList("formula", (AbstractLispTree)this.formula.toLispTree())));
        }
        if (this.value != null) {
            if (Derivation.opts.showValues) {
                tree.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList("value", (AbstractLispTree)this.value.toLispTree())));
            } else if (this.value instanceof ListValue) {
                List<Value> values = ((ListValue)this.value).values;
                if (Derivation.opts.showFirstValue && values.size() > 0) {
                    tree.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList(values.size() + " values", (AbstractLispTree)values.get(0).toLispTree())));
                } else {
                    tree.addChild(values.size() + " values");
                }
            }
        }
        if (this.type != null && Derivation.opts.showTypes) {
            tree.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList("type", (AbstractLispTree)this.type.toLispTree())));
        }
        if (Derivation.opts.showRules && this.rule != null) {
            tree.addChild((AbstractLispTree)this.getRuleLispTree());
        }
        if (Derivation.opts.showUtterance && this.canonicalUtterance != null) {
            tree.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList("canonicalUtterance", this.canonicalUtterance)));
        }
        if (Derivation.opts.showCat && this.cat != null) {
            tree.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList("cat", this.cat)));
        }
        return tree;
    }

    public LispTree toRecursiveLispTree() {
        LispTree tree = (LispTree)LispTree.proto.newList();
        tree.addChild("derivation");
        tree.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList("span", this.cat + "[" + this.start + ":" + this.end + "]")));
        if (this.formula != null) {
            tree.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList("formula", (AbstractLispTree)this.formula.toLispTree())));
        }
        for (Derivation child : this.children) {
            tree.addChild((AbstractLispTree)child.toRecursiveLispTree());
        }
        return tree;
    }

    public String toRecursiveString() {
        return this.toRecursiveLispTree().toString();
    }

    private LispTree getRuleLispTree() {
        LispTree tree = (LispTree)LispTree.proto.newList();
        tree.addChild("rules");
        this.getRuleLispTreeRecurs(tree);
        return tree;
    }

    private void getRuleLispTreeRecurs(LispTree tree) {
        if (this.children.size() > 0) {
            tree.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList("rule", (AbstractLispTree)this.rule.toLispTree())));
            for (Derivation child : this.children) {
                child.getRuleLispTreeRecurs(tree);
            }
        }
    }

    public String startEndString(List<String> tokens) {
        return this.start + ":" + this.end + (this.start == -1 ? "" : tokens.subList(this.start, this.end));
    }

    public String toString() {
        return this.toLispTree().toString();
    }

    public void incrementLocalFeatureVector(double factor, Map<String, Double> map) {
        this.localFeatureVector.increment(factor, map, AllFeatureMatcher.matcher);
    }

    public void incrementAllFeatureVector(double factor, Map<String, Double> map) {
        this.incrementAllFeatureVector(factor, map, AllFeatureMatcher.matcher);
    }

    public void incrementAllFeatureVector(double factor, Map<String, Double> map, FeatureMatcher updateFeatureMatcher) {
        this.localFeatureVector.increment(factor, map, updateFeatureMatcher);
        for (Derivation child : this.children) {
            child.incrementAllFeatureVector(factor, map, updateFeatureMatcher);
        }
    }

    public void incrementAllFeatureVector(double factor, FeatureVector fv) {
        this.localFeatureVector.add(factor, fv);
        for (Derivation child : this.children) {
            child.incrementAllFeatureVector(factor, fv);
        }
    }

    public FeatureVector addPrefixLocalFeatureVector(String prefix) {
        return this.localFeatureVector.addPrefix(prefix);
    }

    public Map<String, Double> getAllFeatureVector() {
        HashMap<String, Double> m = new HashMap<String, Double>();
        this.incrementAllFeatureVector(1.0, m, AllFeatureMatcher.matcher);
        return m;
    }

    public double getAllFeatureVector(String featureName) {
        HashMap<String, Double> m = new HashMap<String, Double>();
        this.incrementAllFeatureVector(1.0, m, new ExactFeatureMatcher(featureName));
        return (Double)MapUtils.get(m, (Object)featureName, (Object)0.0);
    }

    public void addLocalChoice(String choice) {
        if (this.localChoices == null) {
            this.localChoices = new ArrayList<String>();
        }
        this.localChoices.add(choice);
    }

    public void incrementAllChoices(int factor, Map<String, Integer> map) {
        if (Derivation.opts.showRules) {
            MapUtils.incr(map, (Object)("[" + this.start + ":" + this.end + "] " + this.rule.toString()), (int)1);
        }
        if (this.localChoices != null) {
            for (String choice : this.localChoices) {
                MapUtils.incr(map, (Object)choice, (int)factor);
            }
        }
        for (Derivation child : this.children) {
            child.incrementAllChoices(factor, map);
        }
    }

    public void printDerivationRecursively() {
        LogInfo.logs((String)"Deriv: %s(%s,%s) %s", (Object[])new Object[]{this.cat, this.start, this.end, this.formula});
        for (int i = 0; i < this.children.size(); ++i) {
            LogInfo.begin_track((String)"child %s:", (Object[])new Object[]{i});
            this.children.get(i).printDerivationRecursively();
            LogInfo.end_track();
        }
    }

    public static void sortByScore(List<Derivation> trees) {
        Collections.sort(trees, derivScoreComparator);
    }

    public static double[] getProbs(List<Derivation> derivations, double temperature) {
        double[] probs = new double[derivations.size()];
        for (int i = 0; i < derivations.size(); ++i) {
            probs[i] = derivations.get(i).getScore() / temperature;
        }
        if (probs.length > 0) {
            NumUtils.expNormalize((double[])probs);
        }
        return probs;
    }

    public Map<String, Object> getTempState() {
        if (this.tempState == null) {
            this.tempState = new HashMap<String, Object>();
        }
        return this.tempState;
    }

    public void clearTempState() {
        this.tempState = null;
        if (this.children != null) {
            for (Derivation child : this.children) {
                child.clearTempState();
            }
        }
    }

    public int[] getNumAnchors() {
        block7: {
            if (this.numAnchors != null) break block7;
            if (this.rule.isAnchored()) {
                this.numAnchors = new int[this.end];
                for (int i = this.start; i < this.end; ++i) {
                    this.numAnchors[i] = 1;
                }
            } else {
                this.numAnchors = new int[0];
                for (Derivation child : this.children) {
                    int[] childNumAnchors = child.getNumAnchors();
                    if (this.numAnchors.length < childNumAnchors.length) {
                        int[] newNumAnchors = new int[childNumAnchors.length];
                        for (int i = 0; i < this.numAnchors.length; ++i) {
                            newNumAnchors[i] = this.numAnchors[i];
                        }
                        this.numAnchors = newNumAnchors;
                    }
                    for (int i = 0; i < childNumAnchors.length; ++i) {
                        int n = i;
                        this.numAnchors[n] = this.numAnchors[n] + childNumAnchors[i];
                    }
                }
            }
        }
        return this.numAnchors;
    }

    public boolean[] getAnchoredTokens() {
        int[] numAnchors = this.getNumAnchors();
        boolean[] anchoredTokens = new boolean[numAnchors.length];
        for (int i = 0; i < numAnchors.length; ++i) {
            anchoredTokens[i] = numAnchors[i] > 0;
        }
        return anchoredTokens;
    }

    public Derivation betaReduction() {
        Formula reduced = Formulas.betaReduction(this.formula);
        return new Builder().withAllFrom(this).formula(reduced).createDerivation();
    }

    public boolean allAnchored() {
        if (this.rule.isInduced() || !this.allAnchored) {
            this.allAnchored = false;
            return false;
        }
        for (Derivation child : this.children) {
            if (child.allAnchored()) continue;
            return false;
        }
        return true;
    }

    public static class AnchorPriorityScoreComparator
    implements Comparator<Derivation> {
        @Override
        public int compare(Derivation deriv1, Derivation deriv2) {
            boolean deriv1Core = deriv1.allAnchored();
            boolean deriv2Core = deriv2.allAnchored();
            if (deriv1Core && !deriv2Core) {
                return -1;
            }
            if (deriv2Core && !deriv1Core) {
                return 1;
            }
            if (deriv1.score > deriv2.score) {
                return -1;
            }
            if (deriv1.score < deriv2.score) {
                return 1;
            }
            if (deriv1.creationIndex < deriv2.creationIndex) {
                return -1;
            }
            if (deriv1.creationIndex > deriv2.creationIndex) {
                return 1;
            }
            return 0;
        }
    }

    public static class CompatibilityDerivationComparator
    implements Comparator<Derivation> {
        @Override
        public int compare(Derivation deriv1, Derivation deriv2) {
            if (deriv1.compatibility > deriv2.compatibility) {
                return -1;
            }
            if (deriv1.compatibility < deriv2.compatibility) {
                return 1;
            }
            if (deriv1.creationIndex < deriv2.creationIndex) {
                return -1;
            }
            if (deriv1.creationIndex > deriv2.creationIndex) {
                return 1;
            }
            return 0;
        }
    }

    public static class ScoredDerivationComparator
    implements Comparator<Derivation> {
        @Override
        public int compare(Derivation deriv1, Derivation deriv2) {
            if (deriv1.score > deriv2.score) {
                return -1;
            }
            if (deriv1.score < deriv2.score) {
                return 1;
            }
            if (deriv1.creationIndex < deriv2.creationIndex) {
                return -1;
            }
            if (deriv1.creationIndex > deriv2.creationIndex) {
                return 1;
            }
            return 0;
        }
    }

    public static class Builder {
        private String cat;
        private int start;
        private int end;
        private Rule rule;
        private List<Derivation> children;
        private Formula formula;
        private SemType type;
        private FeatureVector localFeatureVector = new FeatureVector();
        private double score = Double.NaN;
        private Value value;
        private Evaluation executorStats;
        private double compatibility = Double.NaN;
        private double prob = Double.NaN;
        private String canonicalUtterance = "";

        public Builder cat(String cat) {
            this.cat = cat;
            return this;
        }

        public Builder start(int start) {
            this.start = start;
            return this;
        }

        public Builder end(int end) {
            this.end = end;
            return this;
        }

        public Builder rule(Rule rule) {
            this.rule = rule;
            return this;
        }

        public Builder children(List<Derivation> children) {
            this.children = children;
            return this;
        }

        public Builder formula(Formula formula) {
            this.formula = formula;
            return this;
        }

        public Builder type(SemType type) {
            this.type = type;
            return this;
        }

        public Builder localFeatureVector(FeatureVector localFeatureVector) {
            this.localFeatureVector = localFeatureVector;
            return this;
        }

        public Builder score(double score) {
            this.score = score;
            return this;
        }

        public Builder value(Value value) {
            this.value = value;
            return this;
        }

        public Builder executorStats(Evaluation executorStats) {
            this.executorStats = executorStats;
            return this;
        }

        public Builder compatibility(double compatibility) {
            this.compatibility = compatibility;
            return this;
        }

        public Builder prob(double prob) {
            this.prob = prob;
            return this;
        }

        public Builder canonicalUtterance(String canonicalUtterance) {
            this.canonicalUtterance = canonicalUtterance;
            return this;
        }

        public Builder withStringFormulaFrom(String value) {
            this.formula = new ValueFormula<StringValue>(new StringValue(value));
            this.type = SemType.stringType;
            return this;
        }

        public Builder withFormulaFrom(Derivation deriv) {
            this.formula = deriv.formula;
            this.type = deriv.type;
            return this;
        }

        public Builder withCallable(SemanticFn.Callable c) {
            this.cat = c.getCat();
            this.start = c.getStart();
            this.end = c.getEnd();
            this.rule = c.getRule();
            this.children = c.getChildren();
            return this;
        }

        public Builder withAllFrom(Derivation deriv) {
            this.cat = deriv.cat;
            this.start = deriv.start;
            this.end = deriv.end;
            this.rule = deriv.rule;
            this.children = deriv.children == null ? null : new ArrayList<Derivation>(deriv.children);
            this.formula = deriv.formula;
            this.type = deriv.type;
            this.localFeatureVector = deriv.localFeatureVector;
            this.score = deriv.score;
            this.value = deriv.value;
            this.executorStats = deriv.executorStats;
            this.compatibility = deriv.compatibility;
            this.prob = deriv.prob;
            this.canonicalUtterance = deriv.canonicalUtterance;
            return this;
        }

        public Derivation createDerivation() {
            return new Derivation(this.cat, this.start, this.end, this.rule, this.children, this.formula, this.type, this.localFeatureVector, this.score, this.value, this.executorStats, this.compatibility, this.prob, this.canonicalUtterance);
        }
    }

    public class GrammarInfo {
        public boolean anchored = false;
        public boolean matched = false;
        public int start = -1;
        public int end = -1;
        public Formula formula;
        public List<Derivation> matches = new ArrayList<Derivation>();
    }

    public static class Options {
        @Option(gloss="When printing derivations, to show values (could be quite verbose)")
        public boolean showValues = true;
        @Option(gloss="When printing derivations, to show the first value (ignored when showValues is set)")
        public boolean showFirstValue = false;
        @Option(gloss="When printing derivations, to show types")
        public boolean showTypes = true;
        @Option(gloss="When printing derivations, to show rules")
        public boolean showRules = false;
        @Option(gloss="When printing derivations, to show canonical utterance")
        public boolean showUtterance = false;
        @Option(gloss="When printing derivations, show the category")
        public boolean showCat = false;
        @Option(gloss="When executing, show formulae (for debugging)")
        public boolean showExecutions = false;
        @Option(gloss="Pick the comparator used to sort derivations")
        public String derivComparator = "ScoredDerivationComparator";
        @Option(gloss="bonus score for being all anchored")
        public double anchoredBonus = 0.0;
    }
}

