/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.google.common.base.Function;
import edu.stanford.nlp.sempre.DefaultDerivationPruningComputer;
import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.DerivationPruningComputer;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.Formula;
import edu.stanford.nlp.sempre.Parser;
import edu.stanford.nlp.sempre.ParserState;
import edu.stanford.nlp.sempre.SempreUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DerivationPruner {
    public static Options opts = new Options();
    public final Parser parser;
    public final Example ex;
    private List<DerivationPruningComputer> pruningComputers = new ArrayList<DerivationPruningComputer>();
    private List<String> customAllowedPruningStrategies;
    private final Set<String> allStrategyNames;

    public DerivationPruner(ParserState parserState) {
        this.parser = parserState.parser;
        this.ex = parserState.ex;
        this.pruningComputers.add(new DefaultDerivationPruningComputer(this));
        for (String pruningComputer : DerivationPruner.opts.pruningComputers) {
            try {
                Class<?> pruningComputerClass = Class.forName(SempreUtils.resolveClassName(pruningComputer));
                this.pruningComputers.add((DerivationPruningComputer)pruningComputerClass.getConstructor(this.getClass()).newInstance(this));
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException("Illegal pruning computer: " + pruningComputer);
            }
            catch (Exception e) {
                e.printStackTrace();
                e.getCause().printStackTrace();
                throw new RuntimeException("Error while instantiating pruning computer: " + pruningComputer);
            }
        }
        this.allStrategyNames = new HashSet<String>();
        for (DerivationPruningComputer computer : this.pruningComputers) {
            this.allStrategyNames.addAll(computer.getAllStrategyNames());
        }
        for (String strategy : DerivationPruner.opts.pruningStrategies) {
            if (this.allStrategyNames.contains(strategy)) continue;
            LogInfo.fails((String)"Pruning strategy '%s' not found!", (Object[])new Object[]{strategy});
        }
    }

    public void setCustomAllowedPruningStrategies(List<String> customAllowedPruningStrategies) {
        this.customAllowedPruningStrategies = customAllowedPruningStrategies;
    }

    protected boolean containsStrategy(String name) {
        return DerivationPruner.opts.pruningStrategies.contains(name) && (this.customAllowedPruningStrategies == null || this.customAllowedPruningStrategies.contains(name));
    }

    public List<DerivationPruningComputer> getPruningComputers() {
        return new ArrayList<DerivationPruningComputer>(this.pruningComputers);
    }

    public boolean isPruned(Derivation deriv) {
        if (DerivationPruner.opts.pruningStrategies.isEmpty() && this.pruningComputers.isEmpty()) {
            return false;
        }
        if (this.isPrunedWithoutExecution(deriv)) {
            return true;
        }
        if (this.isPrunedGeneral(deriv)) {
            return true;
        }
        return this.isPrunedRecursive(deriv);
    }

    boolean isPrunedWithoutExecution(Derivation deriv) {
        for (DerivationPruningComputer computer : this.pruningComputers) {
            String matchedStrategy = computer.isPrunedWithoutExecution(deriv);
            if (matchedStrategy == null) continue;
            if (DerivationPruner.opts.pruningVerbosity >= 2) {
                LogInfo.logs((String)"PRUNED [%s] %s", (Object[])new Object[]{matchedStrategy, deriv.formula});
            }
            return true;
        }
        return false;
    }

    boolean isPrunedGeneral(Derivation deriv) {
        if (!DerivationPruner.opts.ensureExecuted) {
            return false;
        }
        deriv.ensureExecuted(this.parser.executor, this.ex.context);
        for (DerivationPruningComputer computer : this.pruningComputers) {
            String matchedStrategy = computer.isPrunedGeneral(deriv);
            if (matchedStrategy == null) continue;
            if (DerivationPruner.opts.pruningVerbosity >= 2) {
                LogInfo.logs((String)"PRUNED [%s] %s", (Object[])new Object[]{matchedStrategy, deriv.formula});
            }
            return true;
        }
        return false;
    }

    boolean isPrunedRecursive(Derivation deriv) {
        if (!DerivationPruner.opts.recursivePruning) {
            if (DerivationPruner.opts.ensureExecuted) {
                deriv.ensureExecuted(this.parser.executor, this.ex.context);
            }
            for (DerivationPruningComputer computer : this.pruningComputers) {
                String matchedStrategy = computer.isPrunedRecursive(deriv, deriv.formula, new HashMap<String, Object>());
                if (matchedStrategy == null) continue;
                if (DerivationPruner.opts.pruningVerbosity >= 2) {
                    LogInfo.logs((String)"PRUNED [%s] %s", (Object[])new Object[]{matchedStrategy, deriv.formula});
                }
                return true;
            }
        } else {
            PruningRecurser recurser = new PruningRecurser(deriv);
            deriv.formula.forEach(recurser);
            if (recurser.matchedStrategy != null) {
                if (DerivationPruner.opts.pruningVerbosity >= 2) {
                    LogInfo.logs((String)"PRUNED [%s] %s", (Object[])new Object[]{recurser.matchedStrategy, deriv.formula});
                }
                return true;
            }
        }
        return false;
    }

    public boolean isPruned(Derivation deriv, List<String> customAllowedPruningStategies) {
        List<String> old = this.customAllowedPruningStrategies;
        this.customAllowedPruningStrategies = customAllowedPruningStategies;
        boolean answer = this.isPruned(deriv);
        this.customAllowedPruningStrategies = old;
        return answer;
    }

    class PruningRecurser
    implements Function<Formula, Boolean> {
        final Derivation deriv;
        final Map<String, Object> state = new HashMap<String, Object>();
        String matchedStrategy = null;

        public PruningRecurser(Derivation deriv) {
            this.deriv = deriv;
        }

        public Boolean apply(Formula f) {
            if (this.matchedStrategy != null) {
                return true;
            }
            for (DerivationPruningComputer computer : DerivationPruner.this.pruningComputers) {
                this.matchedStrategy = computer.isPrunedRecursive(this.deriv, f, this.state);
                if (this.matchedStrategy == null) continue;
                return true;
            }
            return false;
        }
    }

    public static class Options {
        @Option(gloss="Pruning strategies to use")
        public List<String> pruningStrategies = new ArrayList<String>();
        @Option(gloss="DerivationPruningComputer subclasses to look for pruning strategies")
        public List<String> pruningComputers = new ArrayList<String>();
        @Option
        public int pruningVerbosity = 0;
        @Option(gloss="(for tooManyValues) maximum denotation size of the final formula")
        public int maxNumValues = 10;
        @Option(gloss="(for badSummarizerHead) allow count on sets of size 1")
        public boolean allowCountOne = false;
        @Option(gloss="Ensure that deriv.value contains the executed denotation.")
        public boolean ensureExecuted = true;
        @Option(gloss="If false, apply recursive pruning strategies only at the outermost layer of the formula")
        public boolean recursivePruning = true;
    }
}

