/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.BadFormulaException;
import edu.stanford.nlp.sempre.Value;
import fig.basic.LispTree;

public class ErrorValue
extends Value {
    public static final ErrorValue timeout = new ErrorValue("TIMEOUT");
    public static final ErrorValue server408 = new ErrorValue("SERVER408");
    public static final ErrorValue server500 = new ErrorValue("SERVER500");
    public static final ErrorValue empty = new ErrorValue("EMPTY");
    public static final ErrorValue badFormat = new ErrorValue("BADFORMAT");
    public final String type;

    public static final ErrorValue badFormula(BadFormulaException e) {
        return new ErrorValue("BADFORMULA: " + e);
    }

    public static final ErrorValue badJava(String message) {
        return new ErrorValue("BADJAVA: " + message);
    }

    public ErrorValue(LispTree tree) {
        this.type = ((LispTree)tree.child((int)1)).value;
    }

    public ErrorValue(String type) {
        this.type = type;
    }

    @Override
    public LispTree toLispTree() {
        LispTree tree = (LispTree)LispTree.proto.newList();
        tree.addChild("error");
        tree.addChild(this.type != null ? this.type : "");
        return tree;
    }

    @Override
    public String toString() {
        return this.type;
    }

    public static ErrorValue fromString(String s) {
        if (s.equals(ErrorValue.timeout.type)) {
            return timeout;
        }
        if (s.equals(ErrorValue.server408.type)) {
            return server408;
        }
        if (s.equals(ErrorValue.server500.type)) {
            return server500;
        }
        if (s.equals(ErrorValue.empty.type)) {
            return empty;
        }
        if (s.equals(ErrorValue.badFormat.type)) {
            return badFormat;
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorValue that = (ErrorValue)o;
        return this.type.equals(that.type);
    }

    @Override
    public int hashCode() {
        return this.type.hashCode();
    }
}

