/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import edu.stanford.nlp.sempre.ContextValue;
import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.FeatureVector;
import edu.stanford.nlp.sempre.Formula;
import edu.stanford.nlp.sempre.Formulas;
import edu.stanford.nlp.sempre.Json;
import edu.stanford.nlp.sempre.LanguageAnalyzer;
import edu.stanford.nlp.sempre.LanguageInfo;
import edu.stanford.nlp.sempre.Rule;
import edu.stanford.nlp.sempre.SemType;
import edu.stanford.nlp.sempre.TargetValuePreprocessor;
import edu.stanford.nlp.sempre.Value;
import edu.stanford.nlp.sempre.Values;
import fig.basic.AbstractLispTree;
import fig.basic.Evaluation;
import fig.basic.LispTree;
import fig.basic.LogInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Example {
    @JsonProperty
    public final String id;
    @JsonProperty
    public final String utterance;
    @JsonProperty
    public ContextValue context;
    @JsonProperty
    public Formula targetFormula;
    public List<Formula> alternativeFormulas;
    @JsonProperty
    public Value targetValue;
    public LanguageInfo languageInfo = null;
    public List<Derivation> predDerivations;
    private Map<String, Object> tempState;
    public Evaluation evaluation;

    @JsonCreator
    public Example(@JsonProperty(value="id") String id, @JsonProperty(value="utterance") String utterance, @JsonProperty(value="context") ContextValue context, @JsonProperty(value="targetFormula") Formula targetFormula, @JsonProperty(value="targetValue") Value targetValue, @JsonProperty(value="languageInfo") LanguageInfo languageInfo) {
        this.id = id;
        this.utterance = utterance;
        this.context = context;
        this.targetFormula = targetFormula;
        this.targetValue = targetValue;
        this.languageInfo = languageInfo;
    }

    public String getId() {
        return this.id;
    }

    public String getUtterance() {
        return this.utterance;
    }

    public int numTokens() {
        return this.languageInfo.tokens.size();
    }

    public List<Derivation> getPredDerivations() {
        return this.predDerivations;
    }

    public void setContext(ContextValue context) {
        this.context = context;
    }

    public void setTargetFormula(Formula targetFormula) {
        this.targetFormula = targetFormula;
    }

    public void setAlternativeFormulas(List<Formula> alternativeFormulas) {
        this.alternativeFormulas = alternativeFormulas;
    }

    public void addAlternativeFormula(Formula alternativeFormula) {
        if (this.alternativeFormulas == null) {
            this.alternativeFormulas = new ArrayList<Formula>();
        }
        this.alternativeFormulas.add(alternativeFormula);
    }

    public void setTargetValue(Value targetValue) {
        this.targetValue = targetValue;
    }

    public String spanString(int start, int end) {
        return String.format("%d:%d[%s]", start, end, start != -1 ? this.phraseString(start, end) : "...");
    }

    public String phraseString(int start, int end) {
        return Joiner.on((char)' ').join(this.languageInfo.tokens.subList(start, end));
    }

    public List<String> getTokens() {
        return this.languageInfo.tokens;
    }

    public List<String> getLemmaTokens() {
        return this.languageInfo.lemmaTokens;
    }

    public String token(int i) {
        return this.languageInfo.tokens.get(i);
    }

    public String lemmaToken(int i) {
        return this.languageInfo.lemmaTokens.get(i);
    }

    public String posTag(int i) {
        return this.languageInfo.posTags.get(i);
    }

    public String phrase(int start, int end) {
        return this.languageInfo.phrase(start, end);
    }

    public String lemmaPhrase(int start, int end) {
        return this.languageInfo.lemmaPhrase(start, end);
    }

    public String toJson() {
        return Json.writeValueAsStringHard(this);
    }

    public static Example fromJson(String json) {
        return Json.readValueHard(json, Example.class);
    }

    public static Example fromLispTree(LispTree tree, String defaultId) {
        Builder b = new Builder().setId(defaultId);
        for (int i = 1; i < tree.children.size(); ++i) {
            LispTree arg = (LispTree)tree.child(i);
            String label = ((LispTree)arg.child((int)0)).value;
            if ("id".equals(label)) {
                b.setId(((LispTree)arg.child((int)1)).value);
                continue;
            }
            if ("utterance".equals(label)) {
                b.setUtterance(((LispTree)arg.child((int)1)).value);
                continue;
            }
            if ("canonicalUtterance".equals(label)) {
                b.setUtterance(((LispTree)arg.child((int)1)).value);
                continue;
            }
            if ("targetFormula".equals(label)) {
                b.setTargetFormula(Formulas.fromLispTree((LispTree)arg.child(1)));
                continue;
            }
            if ("targetValue".equals(label) || "targetValues".equals(label)) {
                if (arg.children.size() != 2) {
                    throw new RuntimeException("Expect one target value");
                }
                b.setTargetValue(Values.fromLispTree((LispTree)arg.child(1)));
                continue;
            }
            if (!"context".equals(label)) continue;
            b.setContext(new ContextValue(arg));
        }
        b.setLanguageInfo(new LanguageInfo());
        Example ex = b.createExample();
        for (int i = 1; i < tree.children.size(); ++i) {
            LispTree arg = (LispTree)tree.child(i);
            String label = ((LispTree)arg.child((int)0)).value;
            if ("tokens".equals(label)) {
                for (LispTree child : ((LispTree)arg.child((int)1)).children) {
                    ex.languageInfo.tokens.add(child.value);
                }
                continue;
            }
            if ("lemmaTokens".equals(label)) {
                for (LispTree child : ((LispTree)arg.child((int)1)).children) {
                    ex.languageInfo.lemmaTokens.add(child.value);
                }
                continue;
            }
            if ("posTags".equals(label)) {
                for (LispTree child : ((LispTree)arg.child((int)1)).children) {
                    ex.languageInfo.posTags.add(child.value);
                }
                continue;
            }
            if ("nerTags".equals(label)) {
                for (LispTree child : ((LispTree)arg.child((int)1)).children) {
                    ex.languageInfo.nerTags.add(child.value);
                }
                continue;
            }
            if ("nerValues".equals(label)) {
                for (LispTree child : ((LispTree)arg.child((int)1)).children) {
                    ex.languageInfo.nerValues.add("null".equals(child.value) ? null : child.value);
                }
                continue;
            }
            if ("alternativeFormula".equals(label)) {
                ex.addAlternativeFormula(Formulas.fromLispTree((LispTree)arg.child(1)));
                continue;
            }
            if ("evaluation".equals(label)) {
                ex.evaluation = Evaluation.fromLispTree((LispTree)((LispTree)arg.child(1)));
                continue;
            }
            if ("predDerivations".equals(label)) {
                ex.predDerivations = new ArrayList<Derivation>();
                for (int j = 1; j < arg.children.size(); ++j) {
                    ex.predDerivations.add(Example.derivationFromLispTree((LispTree)arg.child(j)));
                }
                continue;
            }
            if ("rawDerivations".equals(label) || "derivations".equals(label)) {
                ex.predDerivations = new ArrayList<Derivation>();
                for (int j = 1; j < arg.children.size(); ++j) {
                    ex.predDerivations.add(Example.rawDerivationFromLispTree((LispTree)arg.child(j)));
                }
                continue;
            }
            if (Sets.newHashSet((Object[])new String[]{"id", "utterance", "targetFormula", "targetValue", "targetValues", "context", "original"}).contains(label)) continue;
            throw new RuntimeException("Invalid example argument: " + arg);
        }
        return ex;
    }

    public void preprocess() {
        this.languageInfo = LanguageAnalyzer.getSingleton().analyze(this.utterance);
        this.targetValue = TargetValuePreprocessor.getSingleton().preprocess(this.targetValue);
    }

    public void log() {
        LogInfo.begin_track((String)"Example: %s", (Object[])new Object[]{this.utterance});
        LogInfo.logs((String)"Tokens: %s", (Object[])new Object[]{this.getTokens()});
        LogInfo.logs((String)"Lemmatized tokens: %s", (Object[])new Object[]{this.getLemmaTokens()});
        LogInfo.logs((String)"POS tags: %s", (Object[])new Object[]{this.languageInfo.posTags});
        LogInfo.logs((String)"NER tags: %s", (Object[])new Object[]{this.languageInfo.nerTags});
        LogInfo.logs((String)"NER values: %s", (Object[])new Object[]{this.languageInfo.nerValues});
        if (this.context != null) {
            LogInfo.logs((String)"context: %s", (Object[])new Object[]{this.context});
        }
        if (this.targetFormula != null) {
            LogInfo.logs((String)"targetFormula: %s", (Object[])new Object[]{this.targetFormula});
        }
        if (this.targetValue != null) {
            LogInfo.logs((String)"targetValue: %s", (Object[])new Object[]{this.targetValue});
        }
        LogInfo.logs((String)"Dependency children: %s", (Object[])new Object[]{this.languageInfo.dependencyChildren});
        LogInfo.end_track();
    }

    public void logWithoutContext() {
        LogInfo.begin_track((String)"Example: %s", (Object[])new Object[]{this.utterance});
        LogInfo.logs((String)"Tokens: %s", (Object[])new Object[]{this.getTokens()});
        LogInfo.logs((String)"Lemmatized tokens: %s", (Object[])new Object[]{this.getLemmaTokens()});
        LogInfo.logs((String)"POS tags: %s", (Object[])new Object[]{this.languageInfo.posTags});
        LogInfo.logs((String)"NER tags: %s", (Object[])new Object[]{this.languageInfo.nerTags});
        LogInfo.logs((String)"NER values: %s", (Object[])new Object[]{this.languageInfo.nerValues});
        if (this.targetFormula != null) {
            LogInfo.logs((String)"targetFormula: %s", (Object[])new Object[]{this.targetFormula});
        }
        if (this.targetValue != null) {
            LogInfo.logs((String)"targetValue: %s", (Object[])new Object[]{this.targetValue});
        }
        LogInfo.logs((String)"Dependency children: %s", (Object[])new Object[]{this.languageInfo.dependencyChildren});
        LogInfo.end_track();
    }

    public List<Derivation> getCorrectDerivations() {
        ArrayList<Derivation> res = new ArrayList<Derivation>();
        for (Derivation deriv : this.predDerivations) {
            if (deriv.compatibility == Double.NaN) {
                throw new RuntimeException("Compatibility is not set");
            }
            if (!(deriv.compatibility > 0.0)) continue;
            res.add(deriv);
        }
        return res;
    }

    public LispTree toLispTree(boolean outputPredDerivations) {
        LispTree tree = (LispTree)LispTree.proto.newList();
        tree.addChild("example");
        if (this.id != null) {
            tree.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList("id", this.id)));
        }
        if (this.utterance != null) {
            tree.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList("utterance", this.utterance)));
        }
        if (this.targetFormula != null) {
            tree.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList("targetFormula", (AbstractLispTree)this.targetFormula.toLispTree())));
        }
        if (this.targetValue != null) {
            tree.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList("targetValue", (AbstractLispTree)this.targetValue.toLispTree())));
        }
        if (this.languageInfo != null) {
            if (this.languageInfo.tokens != null) {
                tree.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList("tokens", (AbstractLispTree)((LispTree)LispTree.proto.newList(this.languageInfo.tokens)))));
            }
            if (this.languageInfo.posTags != null) {
                tree.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList("posTags", Joiner.on((char)' ').join(this.languageInfo.posTags))));
            }
            if (this.languageInfo.nerTags != null) {
                tree.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList("nerTags", Joiner.on((char)' ').join(this.languageInfo.nerTags))));
            }
        }
        if (this.evaluation != null) {
            tree.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList("evaluation", (AbstractLispTree)this.evaluation.toLispTree())));
        }
        if (this.predDerivations != null && outputPredDerivations) {
            LispTree list = (LispTree)LispTree.proto.newList();
            list.addChild("predDerivations");
            for (Derivation deriv : this.predDerivations) {
                list.addChild((AbstractLispTree)Example.derivationToLispTree(deriv));
            }
            tree.addChild((AbstractLispTree)list);
        }
        return tree;
    }

    public static Derivation derivationFromLispTree(LispTree item) {
        Derivation.Builder b = new Derivation.Builder().cat("$ROOT").start(-1).end(-1).rule(Rule.nullRule).children(new ArrayList<Derivation>());
        int i = 0;
        b.compatibility(Double.parseDouble(((LispTree)item.child((int)i++)).value));
        b.prob(Double.parseDouble(((LispTree)item.child((int)i++)).value));
        b.score(Double.parseDouble(((LispTree)item.child((int)i++)).value));
        LispTree valueTree = (LispTree)item.child(i++);
        if (!valueTree.isLeaf() || !"null".equals(valueTree.value)) {
            b.value(Values.fromLispTree(valueTree));
        }
        b.formula(Formulas.fromLispTree((LispTree)item.child(i++)));
        FeatureVector fv = new FeatureVector();
        LispTree features = (LispTree)item.child(i++);
        for (int j = 0; j < features.children.size(); ++j) {
            fv.addFromString(((LispTree)((LispTree)features.child((int)j)).child((int)0)).value, Double.parseDouble(((LispTree)((LispTree)features.child((int)j)).child((int)1)).value));
        }
        b.localFeatureVector(fv);
        return b.createDerivation();
    }

    public static LispTree derivationToLispTree(Derivation deriv) {
        LispTree item = (LispTree)LispTree.proto.newList();
        item.addChild(deriv.compatibility + "");
        item.addChild(deriv.prob + "");
        item.addChild(deriv.score + "");
        if (deriv.value != null) {
            item.addChild((AbstractLispTree)deriv.value.toLispTree());
        } else {
            item.addChild("null");
        }
        item.addChild((AbstractLispTree)deriv.formula.toLispTree());
        HashMap<String, Double> features = new HashMap<String, Double>();
        deriv.incrementAllFeatureVector(1.0, features);
        item.addChild((AbstractLispTree)((LispTree)LispTree.proto.newList(features)));
        return item;
    }

    public static Derivation rawDerivationFromLispTree(LispTree item) {
        Derivation.Builder b = new Derivation.Builder().cat("$ROOT").start(-1).end(-1).rule(Rule.nullRule).children(new ArrayList<Derivation>());
        for (int i = 1; i < item.children.size(); ++i) {
            LispTree arg = (LispTree)item.child(i);
            String label = ((LispTree)arg.child((int)0)).value;
            if ("formula".equals(label)) {
                b.formula(Formulas.fromLispTree((LispTree)arg.child(1)));
                continue;
            }
            if ("value".equals(label)) {
                b.value(Values.fromLispTree((LispTree)arg.child(1)));
                continue;
            }
            if ("type".equals(label)) {
                b.type(SemType.fromLispTree((LispTree)arg.child(1)));
                continue;
            }
            if ("canonicalUtterance".equals(label)) {
                b.canonicalUtterance(((LispTree)arg.child((int)1)).value);
                continue;
            }
            throw new RuntimeException("Invalid example argument: " + arg);
        }
        return b.createDerivation();
    }

    public static LispTree rawDerivationToLispTree(Derivation deriv) {
        return deriv.toLispTree();
    }

    public Map<String, Object> getTempState() {
        if (this.tempState == null) {
            this.tempState = new HashMap<String, Object>();
        }
        return this.tempState;
    }

    public void clearTempState() {
        this.tempState = null;
    }

    public void clean() {
        this.predDerivations.clear();
        if (this.context.graph != null) {
            this.context.graph.clean();
        }
    }

    public static class Builder {
        private String id;
        private String utterance;
        private ContextValue context;
        private Formula targetFormula;
        private Value targetValue;
        private LanguageInfo languageInfo;

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setUtterance(String utterance) {
            this.utterance = utterance;
            return this;
        }

        public Builder setContext(ContextValue context) {
            this.context = context;
            return this;
        }

        public Builder setTargetFormula(Formula targetFormula) {
            this.targetFormula = targetFormula;
            return this;
        }

        public Builder setTargetValue(Value targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        public Builder setLanguageInfo(LanguageInfo languageInfo) {
            this.languageInfo = languageInfo;
            return this;
        }

        public Builder withExample(Example ex) {
            this.setId(ex.id);
            this.setUtterance(ex.utterance);
            this.setContext(ex.context);
            this.setTargetFormula(ex.targetFormula);
            this.setTargetValue(ex.targetValue);
            return this;
        }

        public Example createExample() {
            return new Example(this.id, this.utterance, this.context, this.targetFormula, this.targetValue, this.languageInfo);
        }
    }
}

