/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Dataset;
import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.Example;
import fig.basic.AbstractLispTree;
import fig.basic.Evaluation;
import fig.basic.IOUtils;
import fig.basic.LispTree;
import fig.basic.LogInfo;
import fig.basic.Pair;
import fig.exec.Execution;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class ExampleUtils {
    private ExampleUtils() {
    }

    public static void writeJson(List<Example> examples) {
        PrintWriter out = IOUtils.openOutHard((String)Execution.getFile((String)"examples.json"));
        for (Example ex : examples) {
            out.println(ex.toJson());
        }
        out.close();
    }

    public static void writeJson(List<Example> examples, String outPath) throws IOException {
        PrintWriter out = IOUtils.openOutHard((String)outPath);
        out.println("[");
        for (int i = 0; i < examples.size(); ++i) {
            Example ex = examples.get(i);
            out.print(ex.toJson());
            out.println(i < examples.size() - 1 ? "," : "");
        }
        out.println("]");
        out.close();
    }

    private static String escapeSpace(String s) {
        return s.replaceAll(" ", "&nbsp;");
    }

    public static void writeSDF(int iter, String group, Evaluation evaluation, List<Example> examples, boolean outputPredDerivations) {
        String basePath = "preds-iter" + iter + "-" + group + ".examples";
        String outPath = Execution.getFile((String)basePath);
        if (outPath == null || examples.size() == 0) {
            return;
        }
        LogInfo.begin_track((String)"Writing examples to %s", (Object[])new Object[]{basePath});
        PrintWriter out = IOUtils.openOutHard((String)outPath);
        LispTree p = LispTree.proto;
        out.println("# SDF version 1.1");
        out.println("# " + p.L(new Object[]{p.L(new Object[]{"iter", iter}), p.L(new Object[]{"group", group}), p.L(new Object[]{"numExamples", examples.size()}), p.L(new Object[]{"evaluation", evaluation.toLispTree()})}));
        for (Example ex : examples) {
            out.println("");
            out.println("example " + ex.id);
            out.println("description " + p.L(new Object[]{p.L(new Object[]{"utterance", ex.utterance}), p.L(new Object[]{"targetValue", ex.targetValue.toLispTree()}), p.L(new Object[]{"evaluation", ex.evaluation.toLispTree()})}));
            if (!outputPredDerivations) continue;
            for (Derivation deriv : ex.predDerivations) {
                StringBuilder buf = new StringBuilder();
                buf.append("item");
                LispTree description = (LispTree)p.newList();
                if (deriv.canonicalUtterance != null) {
                    description.addChild((AbstractLispTree)((LispTree)p.L(new Object[]{"canonicalUtterance", deriv.canonicalUtterance})));
                }
                description.addChild((AbstractLispTree)((LispTree)p.L(new Object[]{"formula", deriv.formula.toLispTree()})));
                description.addChild((AbstractLispTree)((LispTree)p.L(new Object[]{"value", deriv.value.toLispTree()})));
                buf.append("\t" + description);
                buf.append("\t" + deriv.compatibility);
                Map<String, Double> features = deriv.getAllFeatureVector();
                buf.append("\t");
                boolean first = true;
                for (Map.Entry<String, Double> e : features.entrySet()) {
                    if (!first) {
                        buf.append(' ');
                    }
                    first = false;
                    buf.append(e.getKey() + ":" + e.getValue());
                }
                out.println(buf.toString());
            }
        }
        out.close();
        LogInfo.end_track();
    }

    public static void writeParaphraseSDF(int iter, String group, Example ex, boolean outputPredDerivations) {
        String basePath = "preds-iter" + iter + "-" + group + ".examples";
        String outPath = Execution.getFile((String)basePath);
        if (outPath == null) {
            return;
        }
        PrintWriter out = IOUtils.openOutAppendHard((String)outPath);
        out.println("example " + ex.id);
        if (outputPredDerivations) {
            int i = 0;
            for (Derivation deriv : ex.predDerivations) {
                if (deriv.canonicalUtterance != null) {
                    out.println("Pred@" + i + ":\t" + ex.utterance + "\t" + deriv.canonicalUtterance + "\t" + deriv.compatibility + "\t" + deriv.formula + "\t" + deriv.prob);
                }
                ++i;
            }
        }
        out.close();
    }

    public static void writeEvaluationSDF(int iter, String group, Evaluation evaluation, int numExamples) {
        String basePath = "preds-iter" + iter + "-" + group + ".examples";
        String outPath = Execution.getFile((String)basePath);
        if (outPath == null) {
            return;
        }
        PrintWriter out = IOUtils.openOutAppendHard((String)outPath);
        LispTree p = LispTree.proto;
        out.println("");
        out.println("# SDF version 1.1");
        out.println("# " + p.L(new Object[]{p.L(new Object[]{"iter", iter}), p.L(new Object[]{"group", group}), p.L(new Object[]{"numExamples", numExamples}), p.L(new Object[]{"evaluation", evaluation.toLispTree()})}));
        out.close();
    }

    public static void main(String[] args) {
        Dataset dataset = new Dataset();
        Pair pair = Pair.newPair((Object)"train", (Object)args[0]);
        Dataset.opts.splitDevFromTrain = false;
        dataset.readFromPathPairs(Collections.singletonList(pair));
        List<Example> examples = dataset.examples("train");
        try {
            ExampleUtils.writeJson(examples, args[1]);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

