/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.ErrorValue;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.Executor;
import edu.stanford.nlp.sempre.FeatureComputer;
import edu.stanford.nlp.sempre.Formula;
import edu.stanford.nlp.sempre.Formulas;
import edu.stanford.nlp.sempre.LanguageAnalyzer;
import edu.stanford.nlp.sempre.LanguageInfo;
import edu.stanford.nlp.sempre.ListValue;
import edu.stanford.nlp.sempre.NumberValue;
import edu.stanford.nlp.sempre.Rule;
import edu.stanford.nlp.sempre.SemTypeHierarchy;
import edu.stanford.nlp.sempre.SempreUtils;
import edu.stanford.nlp.sempre.StringValue;
import edu.stanford.nlp.sempre.Value;
import fig.basic.MapUtils;
import fig.basic.Option;
import fig.basic.StopWatchSet;
import fig.basic.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class FeatureExtractor {
    private Executor executor;
    private List<FeatureComputer> featureComputers = new ArrayList<FeatureComputer>();
    public static Options opts = new Options();
    public static final String PERSON = "fb:people.person";
    public static final String LOC = "fb:location.location";
    public static final String ORG = "fb:organization.organization";

    public FeatureExtractor(Executor executor) {
        this.executor = executor;
        for (String featureComputer : FeatureExtractor.opts.featureComputers) {
            this.featureComputers.add((FeatureComputer)Utils.newInstanceHard((String)SempreUtils.resolveClassName(featureComputer)));
        }
    }

    public static boolean containsDomain(String domain) {
        if (FeatureExtractor.opts.disableDenotationFeatures && domain.equals("denotation")) {
            return false;
        }
        return FeatureExtractor.opts.useAllFeatures || FeatureExtractor.opts.featureDomains.contains(domain);
    }

    public void extractLocal(Example ex, Derivation deriv) {
        StopWatchSet.begin((String)"FeatureExtractor.extractLocal");
        this.extractRuleFeatures(ex, deriv);
        this.extractSpanFeatures(ex, deriv);
        this.extractDenotationFeatures(ex, deriv);
        this.extractDependencyFeatures(ex, deriv);
        this.extractWhTypeFeatures(ex, deriv);
        this.conjoinLemmaAndBinary(ex, deriv);
        this.extractBigramFeatures(ex, deriv);
        for (FeatureComputer featureComputer : this.featureComputers) {
            featureComputer.extractLocal(ex, deriv);
        }
        StopWatchSet.end();
    }

    void extractRuleFeatures(Example ex, Derivation deriv) {
        if (!FeatureExtractor.containsDomain("rule")) {
            return;
        }
        if (deriv.rule != Rule.nullRule) {
            deriv.addFeature("rule", "fire");
            deriv.addFeature("rule", deriv.rule.toString());
        }
    }

    void extractSpanFeatures(Example ex, Derivation deriv) {
        if (!FeatureExtractor.containsDomain("span") || deriv.start == -1) {
            return;
        }
        deriv.addFeature("span", "cat=" + deriv.cat + ",#tokens=" + (deriv.end - deriv.start));
        deriv.addFeature("span", "cat=" + deriv.cat + ",POS=" + ex.posTag(deriv.start) + "..." + ex.posTag(deriv.end - 1));
    }

    void extractDenotationFeatures(Example ex, Derivation deriv) {
        if (!FeatureExtractor.containsDomain("denotation")) {
            return;
        }
        if (!deriv.isRoot(ex.numTokens())) {
            return;
        }
        deriv.ensureExecuted(this.executor, ex.context);
        if (deriv.value instanceof ErrorValue) {
            deriv.addFeature("denotation", "error");
            return;
        }
        if (deriv.value instanceof StringValue) {
            if (((StringValue)deriv.value).value.equals("[]") || ((StringValue)deriv.value).value.equals("[null]")) {
                deriv.addFeature("denotation", "empty");
            }
            return;
        }
        if (deriv.value instanceof ListValue) {
            ListValue list = (ListValue)deriv.value;
            if (list.values.size() == 1 && list.values.get(0) instanceof NumberValue) {
                int count = this.getNumber(list.values.get(0));
                deriv.addFeature("denotation", "count-size" + (count <= 1 ? "=" + count : ">1"));
            } else {
                int size = list.values.size();
                deriv.addFeature("denotation", "size" + (size < 3 ? "=" + size : ">=3"));
            }
        }
    }

    int getNumber(Value value) {
        if (value instanceof NumberValue) {
            return (int)((NumberValue)value).value;
        }
        if (value instanceof ListValue) {
            return this.getNumber(((ListValue)value).values.get(0));
        }
        throw new RuntimeException("Can't extract number from " + value);
    }

    void extractDependencyFeatures(Example ex, Derivation deriv) {
        if (!FeatureExtractor.containsDomain("dependencyParse") && !FeatureExtractor.containsDomain("fullDependencyParse")) {
            return;
        }
        if (deriv.rule != Rule.nullRule) {
            for (Derivation child : deriv.children) {
                for (int i = child.start; i < child.end; ++i) {
                    for (LanguageInfo.DependencyEdge dependency : ex.languageInfo.dependencyChildren.get(i)) {
                        String containment;
                        if (child.containsIndex(dependency.modifier)) continue;
                        String direction = dependency.modifier > i ? "forward" : "backward";
                        String string = containment = deriv.containsIndex(dependency.modifier) ? "internal" : "external";
                        if (FeatureExtractor.containsDomain("fullDependencyParse")) {
                            this.addAllDependencyFeatures(dependency, direction, containment, deriv);
                            continue;
                        }
                        deriv.addFeature("dependencyParse", "(" + dependency.label + " " + direction + " " + containment + ") --- " + deriv.getRule().toString());
                    }
                }
            }
        }
    }

    private void addAllDependencyFeatures(LanguageInfo.DependencyEdge dependency, String direction, String containment, Derivation deriv) {
        String[] types = new String[]{dependency.label, "*"};
        String[] directions = new String[]{" " + direction, ""};
        String[] containments = new String[]{" " + containment, ""};
        String[] rules = new String[]{deriv.getRule().toString(), ""};
        for (String typePresent : types) {
            for (String directionPresent : directions) {
                for (String containmentPresent : containments) {
                    for (String rulePresent : rules) {
                        deriv.addFeature("fullDependencyParse", "(" + typePresent + directionPresent + containmentPresent + ") --- " + rulePresent);
                    }
                }
            }
        }
    }

    void extractWhTypeFeatures(Example ex, Derivation deriv) {
        if (!FeatureExtractor.containsDomain("whType")) {
            return;
        }
        if (!deriv.isRoot(ex.numTokens())) {
            return;
        }
        if (ex.posTag(0).startsWith("W")) {
            deriv.addFeature("whType", "token0=" + ex.token(0) + ",type=" + FeatureExtractor.coarseType(deriv.type.toString()));
        }
    }

    public static String coarseType(String type) {
        Set<String> superTypes = SemTypeHierarchy.singleton.getSupertypes(type);
        if (superTypes != null) {
            if (superTypes.contains(PERSON)) {
                return PERSON;
            }
            if (superTypes.contains(LOC)) {
                return LOC;
            }
            if (superTypes.contains(ORG)) {
                return ORG;
            }
            if (superTypes.contains("fb:type.number")) {
                return "fb:type.number";
            }
            if (superTypes.contains("fb:type.datetime")) {
                return "fb:type.datetime";
            }
        }
        return "OTHER";
    }

    void conjoinLemmaAndBinary(Example ex, Derivation deriv) {
        if (!FeatureExtractor.containsDomain("lemmaAndBinaries")) {
            return;
        }
        if (!deriv.isRoot(ex.numTokens())) {
            return;
        }
        LinkedList<String> nonEntityLemmas = new LinkedList<String>();
        this.extractNonEntityLemmas(ex, deriv, nonEntityLemmas);
        List<String> binaries = this.extractBinaries(deriv.formula);
        if (!binaries.isEmpty()) {
            String binariesStr = Joiner.on((char)'_').join(binaries);
            for (String nonEntityLemma : nonEntityLemmas) {
                deriv.addFeature("lemmaAndBinaries", "nonEntitylemmas=" + nonEntityLemma + ",binaries=" + binariesStr);
            }
        }
    }

    private void extractUtterance(Derivation deriv, List<String> utterance) {
        if (deriv.rule == Rule.nullRule) {
            return;
        }
        int c = 0;
        for (String item : deriv.rule.rhs) {
            if (Rule.isCat(item)) {
                this.extractUtterance(deriv.children.get(c++), utterance);
                continue;
            }
            utterance.add(item);
        }
    }

    private void extractNonEntityLemmas(Example ex, Derivation deriv, List<String> nonEntityLemmas) {
        if (deriv.children.size() == 0) {
            for (int i = deriv.start; i < deriv.end; ++i) {
                String pos = ex.languageInfo.posTags.get(i);
                if (!pos.startsWith("N") && !pos.startsWith("V") && !pos.startsWith("W") && !pos.startsWith("A") && !pos.equals("IN") || ex.languageInfo.lemmaTokens.get(i).equals("be")) continue;
                nonEntityLemmas.add(ex.languageInfo.lemmaTokens.get(i));
            }
        } else {
            for (Derivation child : deriv.children) {
                if (child.rule.lhs == null || !child.rule.lhs.equals("$Entity")) {
                    this.extractNonEntityLemmas(ex, child, nonEntityLemmas);
                    continue;
                }
                if (!child.rule.lhs.equals("$Entity")) continue;
                nonEntityLemmas.add("E");
            }
        }
    }

    private List<String> extractBinaries(Formula formula) {
        LinkedList<String> res = new LinkedList<String>();
        Set<String> atomicElements = Formulas.extractAtomicFreebaseElements(formula);
        for (String atomicElement : atomicElements) {
            if (atomicElement.split("\\.").length != 3 || atomicElement.equals("fb:type.object.type")) continue;
            res.add(atomicElement);
        }
        return res;
    }

    private void extractBigramFeatures(Example ex, Derivation deriv) {
        if (!FeatureExtractor.containsDomain("bigram")) {
            return;
        }
        if (!deriv.cat.equals("$ROOT")) {
            return;
        }
        LanguageInfo derivInfo = LanguageAnalyzer.getSingleton().analyze(deriv.canonicalUtterance);
        List<String> derivLemmas = derivInfo.lemmaTokens;
        List<String> exLemmas = ex.languageInfo.lemmaTokens;
        HashMap bigramCounts = new HashMap();
        for (int i = 0; i < exLemmas.size() - 1; ++i) {
            for (int j = 0; j < derivLemmas.size() - 1; ++j) {
                if (!derivLemmas.get(j).equals(exLemmas.get(i))) continue;
                for (int k = 1; j + k < derivLemmas.size() && k <= FeatureExtractor.opts.maxBigramDistance; ++k) {
                    if (!derivLemmas.get(j + k).equals(exLemmas.get(i + 1))) continue;
                    if (FeatureExtractor.opts.lexicalBigramParaphrase) {
                        deriv.addFeature("bigram", exLemmas.get(i) + "," + exLemmas.get(i + 1) + " - " + k);
                        continue;
                    }
                    MapUtils.incr(bigramCounts, (Object)k, (int)1);
                }
            }
        }
        if (!FeatureExtractor.opts.lexicalBigramParaphrase) {
            for (Integer dist : bigramCounts.keySet()) {
                deriv.addFeature("bigram", "distance " + dist + " - " + bigramCounts.get(dist));
            }
        }
    }

    String join(List<String> l, String delimiter) {
        StringBuilder sb = new StringBuilder(l.get(0));
        for (int i = 1; i < l.size(); ++i) {
            sb.append(delimiter);
            sb.append(l.get(i));
        }
        return sb.toString();
    }

    public static class Options {
        @Option(gloss="Set of feature domains to include")
        public Set<String> featureDomains = new HashSet<String>();
        @Option(gloss="Set of feature computer classes to load")
        public Set<String> featureComputers = Sets.newHashSet((Object[])new String[]{"DerivOpCountFeatureComputer"});
        @Option(gloss="Disable denotation features")
        public boolean disableDenotationFeatures = false;
        @Option(gloss="Use all possible features, regardless of what featureDomains says")
        public boolean useAllFeatures = false;
        @Option(gloss="For bigram features in paraphrased utterances, maximum distance to consider")
        public int maxBigramDistance = 3;
        @Option(gloss="Whether or not paraphrasing and bigram features should be lexicalized")
        public boolean lexicalBigramParaphrase = true;
    }
}

