/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import edu.stanford.nlp.sempre.AllFeatureMatcher;
import edu.stanford.nlp.sempre.FeatureMatcher;
import edu.stanford.nlp.sempre.Params;
import fig.basic.Fmt;
import fig.basic.LogInfo;
import fig.basic.MapUtils;
import fig.basic.Option;
import fig.basic.Pair;
import fig.basic.ValueComparator;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FeatureVector {
    public static Options opts = new Options();
    private ArrayList<String> indicatorFeatures;
    private ArrayList<Pair<String, Double>> generalFeatures;
    private double[] denseFeatures;
    private static final String DENSE_NAME = "Dns";

    public FeatureVector() {
    }

    public FeatureVector(int numOfDenseFeatures) {
        this.denseFeatures = new double[numOfDenseFeatures];
        Arrays.fill(this.denseFeatures, 0.0);
    }

    private static String toFeature(String domain, String name) {
        return domain + " :: " + name;
    }

    public void add(String domain, String name) {
        this.add(FeatureVector.toFeature(domain, name));
    }

    private void add(String feature) {
        if (this.indicatorFeatures == null) {
            this.indicatorFeatures = new ArrayList();
        }
        this.indicatorFeatures.add(feature);
    }

    public void add(String domain, String name, double value) {
        this.add(FeatureVector.toFeature(domain, name), value);
    }

    private void add(String feature, double value) {
        if (this.generalFeatures == null) {
            this.generalFeatures = new ArrayList();
        }
        this.generalFeatures.add((Pair<String, Double>)Pair.newPair((Object)feature, (Object)value));
    }

    public void addWithBias(String domain, String name, double value) {
        this.add(domain, name, value);
        this.add(domain, name + "-bias", 1.0);
    }

    public void addHistogram(String domain, String name, double value) {
        this.addHistogram(domain, name, value, 2, 10, true);
    }

    public void addHistogram(String domain, String name, double value, int initBinSize, int numBins, boolean exp) {
        double upper = initBinSize;
        String bin = null;
        int sign = value > 0.0 ? 1 : -1;
        value = Math.abs(value);
        for (int i = 0; i < numBins; ++i) {
            double lastUpper = upper;
            if (i > 0) {
                upper = exp ? (upper *= (double)initBinSize) : (upper += (double)initBinSize);
            }
            if (!(value < upper)) continue;
            bin = sign > 0 ? lastUpper + ":" + upper : -upper + ":" + -lastUpper;
            break;
        }
        if (bin == null) {
            bin = sign > 0 ? ">=" + upper : "<=" + -upper;
        }
        this.add(domain, name + bin);
    }

    public void addFromString(String feature, double value) {
        assert (feature.contains(" :: ")) : feature;
        if (value == 1.0) {
            this.add(feature);
        } else {
            this.add(feature, value);
        }
    }

    public void addDenseFeature(int index, double value) {
        int n = index;
        this.denseFeatures[n] = this.denseFeatures[n] + value;
    }

    public void add(FeatureVector that) {
        this.add(that, AllFeatureMatcher.matcher);
    }

    public void add(double scale, FeatureVector that) {
        this.add(scale, that, AllFeatureMatcher.matcher);
    }

    public void add(FeatureVector that, FeatureMatcher matcher) {
        this.add(1.0, that, matcher);
    }

    public void add(double scale, FeatureVector that, FeatureMatcher matcher) {
        if (that.indicatorFeatures != null) {
            for (String string : that.indicatorFeatures) {
                if (!matcher.matches(string)) continue;
                if (scale == 1.0) {
                    this.add(string);
                    continue;
                }
                this.add(string, scale);
            }
        }
        if (that.generalFeatures != null) {
            for (Pair pair : that.generalFeatures) {
                if (!matcher.matches((String)pair.getFirst())) continue;
                this.add((String)pair.getFirst(), scale * (Double)pair.getSecond());
            }
        }
        if (that.denseFeatures != null) {
            for (int i = 0; i < this.denseFeatures.length; ++i) {
                int n = i;
                this.denseFeatures[n] = this.denseFeatures[n] + scale * that.denseFeatures[i];
            }
        }
    }

    public double dotProduct(Params params) {
        double sum = 0.0;
        if (this.indicatorFeatures != null) {
            for (String string : this.indicatorFeatures) {
                sum += params.getWeight(string);
            }
        }
        if (this.generalFeatures != null) {
            for (Pair pair : this.generalFeatures) {
                sum += params.getWeight((String)pair.getFirst()) * (Double)pair.getSecond();
            }
        }
        if (this.denseFeatures != null) {
            for (int i = 0; i < this.denseFeatures.length; ++i) {
                sum += params.getWeight("Dns_" + i) * this.denseFeatures[i];
            }
        }
        return sum;
    }

    public void increment(double factor, Map<String, Double> map) {
        this.increment(factor, map, AllFeatureMatcher.matcher);
    }

    public void increment(double factor, Map<String, Double> map, FeatureMatcher matcher) {
        if (this.indicatorFeatures != null) {
            for (String string : this.indicatorFeatures) {
                if (!matcher.matches(string)) continue;
                MapUtils.incr(map, (Object)string, (double)factor);
            }
        }
        if (this.generalFeatures != null) {
            for (Pair pair : this.generalFeatures) {
                if (!matcher.matches((String)pair.getFirst())) continue;
                MapUtils.incr(map, (Object)((String)pair.getFirst()), (double)(factor * (Double)pair.getSecond()));
            }
        }
        if (this.denseFeatures != null) {
            for (int i = 0; i < this.denseFeatures.length; ++i) {
                MapUtils.incr(map, (Object)("Dns_" + i), (double)(factor * this.denseFeatures[i]));
            }
        }
    }

    public FeatureVector addPrefix(String prefix) {
        FeatureVector res = new FeatureVector();
        if (this.indicatorFeatures != null) {
            for (String string : this.indicatorFeatures) {
                res.add(prefix + string);
            }
        }
        if (this.generalFeatures != null) {
            for (Pair pair : this.generalFeatures) {
                res.add(prefix + (String)pair.getFirst(), (Double)pair.getSecond());
            }
        }
        return res;
    }

    @JsonValue
    public Map<String, Double> toMap() {
        HashMap<String, Double> map = new HashMap<String, Double>();
        this.increment(1.0, map);
        if (this.denseFeatures != null) {
            for (int i = 0; i < this.denseFeatures.length; ++i) {
                map.put("Dns_" + i, this.denseFeatures[i]);
            }
        }
        return map;
    }

    @JsonCreator
    public static FeatureVector fromMap(Map<String, Double> m) {
        int maxDenseFeaturesIndex = -1;
        for (Map.Entry<String, Double> entry : m.entrySet()) {
            int index;
            if (!FeatureVector.isDenseFeature(entry.getKey()) || (index = FeatureVector.denseFeatureIndex(entry.getKey())) <= maxDenseFeaturesIndex) continue;
            maxDenseFeaturesIndex = index;
        }
        FeatureVector fv = maxDenseFeaturesIndex == -1 ? new FeatureVector() : new FeatureVector(maxDenseFeaturesIndex + 1);
        for (Map.Entry<String, Double> entry : m.entrySet()) {
            if (FeatureVector.isDenseFeature(entry.getKey())) {
                fv.addDenseFeature(FeatureVector.denseFeatureIndex(entry.getKey()), entry.getValue());
                continue;
            }
            if (entry.getValue() == 1.0) {
                fv.add(entry.getKey());
                continue;
            }
            fv.add(entry.getKey(), entry.getValue());
        }
        return fv;
    }

    private static boolean isDenseFeature(String f) {
        return f.startsWith(DENSE_NAME);
    }

    private static int denseFeatureIndex(String denseFeature) {
        assert (denseFeature.startsWith(DENSE_NAME));
        return Integer.parseInt(denseFeature.split("_")[1]);
    }

    public static void logChoices(String prefix, Map<String, Integer> choices) {
        LogInfo.begin_track((String)"%s choices", (Object[])new Object[]{prefix});
        for (Map.Entry<String, Integer> e : choices.entrySet()) {
            int value = e.getValue();
            if (value == 0) continue;
            LogInfo.logs((String)"%s %s", (Object[])new Object[]{value > 0 ? "+" + value : Integer.valueOf(value), e.getKey()});
        }
        LogInfo.end_track();
    }

    public static void logFeatureWeights(String prefix, Map<String, Double> features, Params params) {
        double value;
        String feature;
        ArrayList<AbstractMap.SimpleEntry<String, Double>> entries = new ArrayList<AbstractMap.SimpleEntry<String, Double>>();
        double sumValue = 0.0;
        for (Map.Entry<String, Double> entry : features.entrySet()) {
            feature = entry.getKey();
            if (entry.getValue() == 0.0) continue;
            value = entry.getValue() * params.getWeight(feature);
            if (FeatureVector.opts.ignoreZeroWeight && value == 0.0) continue;
            sumValue += value;
            entries.add(new AbstractMap.SimpleEntry<String, Double>(feature, value));
        }
        Collections.sort(entries, new ValueComparator(false));
        LogInfo.begin_track_printAll((String)"%s features [sum = %s] (format is feature value * weight)", (Object[])new Object[]{prefix, Fmt.D((double)sumValue)});
        if (entries.size() / 2 > FeatureVector.opts.logFeaturesLimit) {
            double weight;
            for (Map.Entry<String, Double> entry : entries.subList(0, FeatureVector.opts.logFeaturesLimit)) {
                feature = entry.getKey();
                value = entry.getValue();
                weight = params.getWeight(feature);
                LogInfo.logs((String)"%-50s %6s = %s * %s", (Object[])new Object[]{"[ " + feature + " ]", Fmt.D((double)value), Fmt.D((double)MapUtils.getDouble(features, (Object)feature, (double)0.0)), Fmt.D((double)weight)});
            }
            LogInfo.logs((String)"... (%d more features) ...", (Object[])new Object[]{entries.size() - 2 * FeatureVector.opts.logFeaturesLimit});
            for (Map.Entry<String, Double> entry : entries.subList(entries.size() - FeatureVector.opts.logFeaturesLimit, entries.size())) {
                feature = entry.getKey();
                value = entry.getValue();
                weight = params.getWeight(feature);
                LogInfo.logs((String)"%-50s %6s = %s * %s", (Object[])new Object[]{"[ " + feature + " ]", Fmt.D((double)value), Fmt.D((double)MapUtils.getDouble(features, (Object)feature, (double)0.0)), Fmt.D((double)weight)});
            }
        } else {
            for (Map.Entry<String, Double> entry : entries) {
                feature = entry.getKey();
                value = entry.getValue();
                double weight = params.getWeight(feature);
                LogInfo.logs((String)"%-50s %6s = %s * %s", (Object[])new Object[]{"[ " + feature + " ]", Fmt.D((double)value), Fmt.D((double)MapUtils.getDouble(features, (Object)feature, (double)0.0)), Fmt.D((double)weight)});
            }
        }
        LogInfo.end_track();
    }

    public static void logFeatures(Map<String, Double> features) {
        for (String key : features.keySet()) {
            LogInfo.logs((String)"%s\t%s", (Object[])new Object[]{key, features.get(key)});
        }
    }

    public void clear() {
        if (this.indicatorFeatures != null) {
            this.indicatorFeatures.clear();
        }
        if (this.generalFeatures != null) {
            this.generalFeatures.clear();
        }
        this.denseFeatures = null;
    }

    public static class Options {
        @Option(gloss="When logging, ignore features with zero weight")
        public boolean ignoreZeroWeight = false;
        @Option(gloss="Log only this number of top and bottom features")
        public int logFeaturesLimit = Integer.MAX_VALUE;
    }
}

