/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.DerivationStream;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.SemanticFn;
import edu.stanford.nlp.sempre.SingleDerivationStream;
import fig.basic.LispTree;
import java.util.ArrayList;
import java.util.List;

public class FilterNerSpanFn
extends SemanticFn {
    List<String> acceptableNerTags = new ArrayList<String>();

    @Override
    public void init(LispTree tree) {
        super.init(tree);
        for (int j = 1; j < tree.children.size(); ++j) {
            this.acceptableNerTags.add(((LispTree)tree.child((int)j)).value);
        }
    }

    @Override
    public DerivationStream call(final Example ex, final SemanticFn.Callable c) {
        return new SingleDerivationStream(){

            @Override
            public Derivation createDerivation() {
                if (!FilterNerSpanFn.this.isValid(ex, c)) {
                    return null;
                }
                return new Derivation.Builder().withCallable(c).withFormulaFrom(c.child(0)).createDerivation();
            }
        };
    }

    private boolean isValid(Example ex, SemanticFn.Callable c) {
        String nerTag = ex.languageInfo.nerTags.get(c.getStart());
        if (!this.acceptableNerTags.contains(nerTag)) {
            return false;
        }
        for (int j = c.getStart() + 1; j < c.getEnd(); ++j) {
            if (nerTag.equals(ex.languageInfo.nerTags.get(j))) continue;
            return false;
        }
        if (c.getStart() > 0 && nerTag.equals(ex.languageInfo.nerTags.get(c.getStart() - 1))) {
            return false;
        }
        if (c.getEnd() < ex.languageInfo.nerTags.size() && nerTag.equals(ex.languageInfo.nerTags.get(c.getEnd()))) {
            return false;
        }
        assert (c.getChildren().size() == 1) : c.getChildren();
        return true;
    }
}

