/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.DerivationStream;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.SemanticFn;
import edu.stanford.nlp.sempre.SingleDerivationStream;
import fig.basic.LispTree;
import java.util.ArrayList;
import java.util.List;

public class FilterPosTagFn
extends SemanticFn {
    List<String> posTags = new ArrayList<String>();
    String mode;
    boolean reverse;

    @Override
    public void init(LispTree tree) {
        super.init(tree);
        this.mode = ((LispTree)tree.child((int)1)).value;
        if (!this.mode.equals("span") && !this.mode.equals("token")) {
            throw new RuntimeException("Illegal description for whether to filter by token or span: " + ((LispTree)tree.child((int)1)).value);
        }
        for (int j = 2; j < tree.children.size(); ++j) {
            if (j == 2 && ((LispTree)tree.child((int)2)).value.equals("reverse")) {
                this.reverse = true;
                continue;
            }
            this.posTags.add(((LispTree)tree.child((int)j)).value);
        }
    }

    @Override
    public DerivationStream call(final Example ex, final SemanticFn.Callable c) {
        return new SingleDerivationStream(){

            @Override
            public Derivation createDerivation() {
                if (FilterPosTagFn.this.mode.equals("span")) {
                    return FilterPosTagFn.this.callSpan(ex, c);
                }
                return FilterPosTagFn.this.callToken(ex, c);
            }
        };
    }

    private Derivation callToken(Example ex, SemanticFn.Callable c) {
        String posTag = ex.posTag(c.getStart());
        if (c.getEnd() - c.getStart() != 1 || !this.posTags.contains(posTag) ^ this.reverse) {
            return null;
        }
        return new Derivation.Builder().withCallable(c).withFormulaFrom(c.child(0)).createDerivation();
    }

    private Derivation callSpan(Example ex, SemanticFn.Callable c) {
        if (this.isValidSpan(ex, c)) {
            return new Derivation.Builder().withCallable(c).withFormulaFrom(c.child(0)).createDerivation();
        }
        return null;
    }

    private boolean isValidSpan(Example ex, SemanticFn.Callable c) {
        if (this.reverse) {
            for (int j = c.getStart(); j < c.getEnd(); ++j) {
                if (!this.posTags.contains(ex.posTag(j))) continue;
                return false;
            }
            return true;
        }
        String posTag = ex.posTag(c.getStart());
        if (!this.posTags.contains(posTag)) {
            return false;
        }
        for (int j = c.getStart() + 1; j < c.getEnd(); ++j) {
            if (posTag.equals(ex.posTag(j))) continue;
            return false;
        }
        if (c.getStart() > 0 && posTag.equals(ex.posTag(c.getStart() - 1))) {
            return false;
        }
        if (c.getEnd() < ex.numTokens() && posTag.equals(ex.posTag(c.getEnd()))) {
            return false;
        }
        assert (c.getChildren().size() == 1) : c.getChildren();
        return true;
    }
}

