/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.DerivationStream;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.SemanticFn;
import edu.stanford.nlp.sempre.SingleDerivationStream;
import fig.basic.LispTree;

public class FilterSpanLengthFn
extends SemanticFn {
    private int minLength;
    private int maxLength;
    private static final int NO_MAXIMUM = -1;

    public FilterSpanLengthFn() {
    }

    public FilterSpanLengthFn(int minLength) {
        this.init((LispTree)LispTree.proto.newList("FilterSpanLengthFn", "" + minLength));
    }

    @Override
    public void init(LispTree tree) {
        super.init(tree);
        this.minLength = Integer.parseInt(((LispTree)tree.child((int)1)).value);
        this.maxLength = tree.children.size() > 2 ? Integer.parseInt(((LispTree)tree.child((int)2)).value) : -1;
    }

    @Override
    public DerivationStream call(Example ex, final SemanticFn.Callable c) {
        return new SingleDerivationStream(){

            @Override
            public Derivation createDerivation() {
                if (c.getEnd() - c.getStart() < FilterSpanLengthFn.this.minLength) {
                    return null;
                }
                if (FilterSpanLengthFn.this.maxLength != -1 && c.getEnd() - c.getStart() > FilterSpanLengthFn.this.maxLength) {
                    return null;
                }
                return new Derivation.Builder().withCallable(c).withFormulaFrom(c.child(0)).createDerivation();
            }
        };
    }
}

