/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.DerivationStream;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.SemanticFn;
import edu.stanford.nlp.sempre.SingleDerivationStream;
import fig.basic.LispTree;
import java.util.ArrayList;
import java.util.List;

public class FilterTokenFn
extends SemanticFn {
    List<String> acceptableTokens = new ArrayList<String>();
    String mode;

    @Override
    public void init(LispTree tree) {
        super.init(tree);
        this.mode = ((LispTree)tree.child((int)1)).value;
        if (!this.mode.equals("token") && !this.mode.equals("lemma")) {
            throw new RuntimeException("Illegal description for FilterTokenFn: " + this.mode);
        }
        for (int j = 2; j < tree.children.size(); ++j) {
            this.acceptableTokens.add(((LispTree)tree.child((int)j)).value);
        }
    }

    @Override
    public DerivationStream call(final Example ex, final SemanticFn.Callable c) {
        return new SingleDerivationStream(){

            @Override
            public Derivation createDerivation() {
                if (!FilterTokenFn.this.isValid(ex, c)) {
                    return null;
                }
                return new Derivation.Builder().withCallable(c).withFormulaFrom(c.child(0)).createDerivation();
            }
        };
    }

    private boolean isValid(Example ex, SemanticFn.Callable c) {
        if (c.getEnd() - c.getStart() != 1) {
            return false;
        }
        String token = "token".equals(this.mode) ? ex.token(c.getStart()) : ex.lemmaToken(c.getStart());
        return this.acceptableTokens.contains(token);
    }
}

