/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sempre;

import edu.stanford.nlp.sempre.Derivation;
import edu.stanford.nlp.sempre.Example;
import edu.stanford.nlp.sempre.FeatureComputer;
import edu.stanford.nlp.sempre.FeatureExtractor;
import fig.basic.IntPair;
import java.util.ArrayList;

public class FloatingFeatureComputer
implements FeatureComputer {
    @Override
    public void extractLocal(Example ex, Derivation deriv) {
        this.extractFloatingRuleFeatures(ex, deriv);
        this.extractFloatingSkipFeatures(ex, deriv);
    }

    void extractFloatingRuleFeatures(Example ex, Derivation deriv) {
        if (!FeatureExtractor.containsDomain("floatRule")) {
            return;
        }
        for (String lemma : ex.getLemmaTokens()) {
            deriv.addFeature("floatRule", "lemma=" + lemma + ",rule=" + deriv.rule.toString());
        }
    }

    void extractFloatingSkipFeatures(Example ex, Derivation deriv) {
        if (!FeatureExtractor.containsDomain("floatSkip")) {
            return;
        }
        if (!deriv.isRoot(ex.numTokens())) {
            return;
        }
        boolean[] anchored = new boolean[ex.numTokens()];
        ArrayList<Derivation> stack = new ArrayList<Derivation>();
        stack.add(deriv);
        while (!stack.isEmpty()) {
            Derivation currentDeriv = (Derivation)stack.remove(stack.size() - 1);
            if (deriv.start != -1) {
                for (int i = deriv.start; i < deriv.end; ++i) {
                    anchored[i] = true;
                }
                continue;
            }
            for (Derivation child : currentDeriv.children) {
                stack.add(child);
            }
        }
        block3: for (IntPair pair : ex.languageInfo.getNamedEntitySpans()) {
            for (int i = pair.first; i < pair.second; ++i) {
                if (anchored[i]) continue;
                String nerTag = ex.languageInfo.nerTags.get(i);
                deriv.addFeature("floatSkip", "skipped-ner=" + nerTag);
                continue block3;
            }
        }
        for (int i = 0; i < anchored.length; ++i) {
            if (anchored[i]) continue;
            deriv.addFeature("floatSkip", "skipped-pos=" + ex.posTag(i));
        }
    }
}

